/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckpointDurableExecutionRequest extends LambdaRequest implements
        ToCopyableBuilder<CheckpointDurableExecutionRequest.Builder, CheckpointDurableExecutionRequest> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(CheckpointDurableExecutionRequest::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DurableExecutionArn").build()).build();

    private static final SdkField<String> CHECKPOINT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckpointToken").getter(getter(CheckpointDurableExecutionRequest::checkpointToken))
            .setter(setter(Builder::checkpointToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointToken").build()).build();

    private static final SdkField<List<OperationUpdate>> UPDATES_FIELD = SdkField
            .<List<OperationUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(CheckpointDurableExecutionRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperationUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperationUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CheckpointDurableExecutionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD,
            CHECKPOINT_TOKEN_FIELD, UPDATES_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String durableExecutionArn;

    private final String checkpointToken;

    private final List<OperationUpdate> updates;

    private final String clientToken;

    private CheckpointDurableExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.checkpointToken = builder.checkpointToken;
        this.updates = builder.updates;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    /**
     * <p>
     * A unique token that identifies the current checkpoint state. This token is provided by the Lambda runtime and
     * must be used to ensure checkpoints are applied in the correct order. Each checkpoint operation consumes this
     * token and returns a new one.
     * </p>
     * 
     * @return A unique token that identifies the current checkpoint state. This token is provided by the Lambda runtime
     *         and must be used to ensure checkpoints are applied in the correct order. Each checkpoint operation
     *         consumes this token and returns a new one.
     */
    public final String checkpointToken() {
        return checkpointToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of state updates to apply during this checkpoint. Each update represents a change to the execution
     * state, such as completing a step, starting a callback, or scheduling a timer. Updates are applied atomically as
     * part of the checkpoint operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return An array of state updates to apply during this checkpoint. Each update represents a change to the
     *         execution state, such as completing a step, starting a callback, or scheduling a timer. Updates are
     *         applied atomically as part of the checkpoint operation.
     */
    public final List<OperationUpdate> updates() {
        return updates;
    }

    /**
     * <p>
     * An optional idempotency token to ensure that duplicate checkpoint requests are handled correctly. If provided,
     * Lambda uses this token to detect and handle duplicate requests within a 15-minute window.
     * </p>
     * 
     * @return An optional idempotency token to ensure that duplicate checkpoint requests are handled correctly. If
     *         provided, Lambda uses this token to detect and handle duplicate requests within a 15-minute window.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointDurableExecutionRequest)) {
            return false;
        }
        CheckpointDurableExecutionRequest other = (CheckpointDurableExecutionRequest) obj;
        return Objects.equals(durableExecutionArn(), other.durableExecutionArn())
                && Objects.equals(checkpointToken(), other.checkpointToken()) && hasUpdates() == other.hasUpdates()
                && Objects.equals(updates(), other.updates()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckpointDurableExecutionRequest").add("DurableExecutionArn", durableExecutionArn())
                .add("CheckpointToken", checkpointToken()).add("Updates", hasUpdates() ? updates() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        case "CheckpointToken":
            return Optional.ofNullable(clazz.cast(checkpointToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("CheckpointToken", CHECKPOINT_TOKEN_FIELD);
        map.put("Updates", UPDATES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckpointDurableExecutionRequest, T> g) {
        return obj -> g.apply((CheckpointDurableExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckpointDurableExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) of the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);

        /**
         * <p>
         * A unique token that identifies the current checkpoint state. This token is provided by the Lambda runtime and
         * must be used to ensure checkpoints are applied in the correct order. Each checkpoint operation consumes this
         * token and returns a new one.
         * </p>
         * 
         * @param checkpointToken
         *        A unique token that identifies the current checkpoint state. This token is provided by the Lambda
         *        runtime and must be used to ensure checkpoints are applied in the correct order. Each checkpoint
         *        operation consumes this token and returns a new one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointToken(String checkpointToken);

        /**
         * <p>
         * An array of state updates to apply during this checkpoint. Each update represents a change to the execution
         * state, such as completing a step, starting a callback, or scheduling a timer. Updates are applied atomically
         * as part of the checkpoint operation.
         * </p>
         * 
         * @param updates
         *        An array of state updates to apply during this checkpoint. Each update represents a change to the
         *        execution state, such as completing a step, starting a callback, or scheduling a timer. Updates are
         *        applied atomically as part of the checkpoint operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<OperationUpdate> updates);

        /**
         * <p>
         * An array of state updates to apply during this checkpoint. Each update represents a change to the execution
         * state, such as completing a step, starting a callback, or scheduling a timer. Updates are applied atomically
         * as part of the checkpoint operation.
         * </p>
         * 
         * @param updates
         *        An array of state updates to apply during this checkpoint. Each update represents a change to the
         *        execution state, such as completing a step, starting a callback, or scheduling a timer. Updates are
         *        applied atomically as part of the checkpoint operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(OperationUpdate... updates);

        /**
         * <p>
         * An array of state updates to apply during this checkpoint. Each update represents a change to the execution
         * state, such as completing a step, starting a callback, or scheduling a timer. Updates are applied atomically
         * as part of the checkpoint operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.OperationUpdate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lambda.model.OperationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.OperationUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #updates(List<OperationUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.OperationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(java.util.Collection<OperationUpdate>)
         */
        Builder updates(Consumer<OperationUpdate.Builder>... updates);

        /**
         * <p>
         * An optional idempotency token to ensure that duplicate checkpoint requests are handled correctly. If
         * provided, Lambda uses this token to detect and handle duplicate requests within a 15-minute window.
         * </p>
         * 
         * @param clientToken
         *        An optional idempotency token to ensure that duplicate checkpoint requests are handled correctly. If
         *        provided, Lambda uses this token to detect and handle duplicate requests within a 15-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String durableExecutionArn;

        private String checkpointToken;

        private List<OperationUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointDurableExecutionRequest model) {
            super(model);
            durableExecutionArn(model.durableExecutionArn);
            checkpointToken(model.checkpointToken);
            updates(model.updates);
            clientToken(model.clientToken);
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getCheckpointToken() {
            return checkpointToken;
        }

        public final void setCheckpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
        }

        @Override
        public final Builder checkpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
            return this;
        }

        public final List<OperationUpdate.Builder> getUpdates() {
            List<OperationUpdate.Builder> result = OperationUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<OperationUpdate.BuilderImpl> updates) {
            this.updates = OperationUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<OperationUpdate> updates) {
            this.updates = OperationUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(OperationUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<OperationUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> OperationUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckpointDurableExecutionRequest build() {
            return new CheckpointDurableExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
