/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.Architecture;
import software.amazon.awssdk.services.lambda.model.ArchitecturesListCopier;
import software.amazon.awssdk.services.lambda.model.InstanceTypeSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRequirements> {
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Architectures").getter(InstanceRequirements.getter(InstanceRequirements::architecturesAsStrings)).setter(InstanceRequirements.setter(Builder::architecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedInstanceTypes").getter(InstanceRequirements.getter(InstanceRequirements::allowedInstanceTypes)).setter(InstanceRequirements.setter(Builder::allowedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedInstanceTypes").getter(InstanceRequirements.getter(InstanceRequirements::excludedInstanceTypes)).setter(InstanceRequirements.setter(Builder::excludedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURES_FIELD, ALLOWED_INSTANCE_TYPES_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceRequirements.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> architectures;
    private final List<String> allowedInstanceTypes;
    private final List<String> excludedInstanceTypes;

    private InstanceRequirements(BuilderImpl builder) {
        this.architectures = builder.architectures;
        this.allowedInstanceTypes = builder.allowedInstanceTypes;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
    }

    public final List<Architecture> architectures() {
        return ArchitecturesListCopier.copyStringToEnum(this.architectures);
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architecturesAsStrings() {
        return this.architectures;
    }

    public final boolean hasAllowedInstanceTypes() {
        return this.allowedInstanceTypes != null && !(this.allowedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> allowedInstanceTypes() {
        return this.allowedInstanceTypes;
    }

    public final boolean hasExcludedInstanceTypes() {
        return this.excludedInstanceTypes != null && !(this.excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludedInstanceTypes() {
        return this.excludedInstanceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedInstanceTypes() ? this.allowedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRequirements)) {
            return false;
        }
        InstanceRequirements other = (InstanceRequirements)obj;
        return this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architecturesAsStrings(), other.architecturesAsStrings()) && this.hasAllowedInstanceTypes() == other.hasAllowedInstanceTypes() && Objects.equals(this.allowedInstanceTypes(), other.allowedInstanceTypes()) && this.hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes() && Objects.equals(this.excludedInstanceTypes(), other.excludedInstanceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRequirements").add("Architectures", this.hasArchitectures() ? this.architecturesAsStrings() : null).add("AllowedInstanceTypes", this.hasAllowedInstanceTypes() ? this.allowedInstanceTypes() : null).add("ExcludedInstanceTypes", this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architectures": {
                return Optional.ofNullable(clazz.cast(this.architecturesAsStrings()));
            }
            case "AllowedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.allowedInstanceTypes()));
            }
            case "ExcludedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.excludedInstanceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Architectures", ARCHITECTURES_FIELD);
        map.put("AllowedInstanceTypes", ALLOWED_INSTANCE_TYPES_FIELD);
        map.put("ExcludedInstanceTypes", EXCLUDED_INSTANCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceRequirements, T> g) {
        return obj -> g.apply((InstanceRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRequirements model) {
            this.architecturesWithStrings(model.architectures);
            this.allowedInstanceTypes(model.allowedInstanceTypes);
            this.excludedInstanceTypes(model.excludedInstanceTypes);
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
        }

        @Override
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecturesWithStrings(String ... architectures) {
            this.architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitecturesListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Architecture ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final Collection<String> getAllowedInstanceTypes() {
            if (this.allowedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedInstanceTypes;
        }

        public final void setAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
            this.allowedInstanceTypes = InstanceTypeSetCopier.copy(allowedInstanceTypes);
        }

        @Override
        public final Builder allowedInstanceTypes(Collection<String> allowedInstanceTypes) {
            this.allowedInstanceTypes = InstanceTypeSetCopier.copy(allowedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedInstanceTypes(String ... allowedInstanceTypes) {
            this.allowedInstanceTypes(Arrays.asList(allowedInstanceTypes));
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (this.excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = InstanceTypeSetCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = InstanceTypeSetCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String ... excludedInstanceTypes) {
            this.excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public InstanceRequirements build() {
            return new InstanceRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRequirements> {
        public Builder architecturesWithStrings(Collection<String> var1);

        public Builder architecturesWithStrings(String ... var1);

        public Builder architectures(Collection<Architecture> var1);

        public Builder architectures(Architecture ... var1);

        public Builder allowedInstanceTypes(Collection<String> var1);

        public Builder allowedInstanceTypes(String ... var1);

        public Builder excludedInstanceTypes(Collection<String> var1);

        public Builder excludedInstanceTypes(String ... var1);
    }
}

