/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventType {
    EXECUTION_STARTED("ExecutionStarted"),
    EXECUTION_SUCCEEDED("ExecutionSucceeded"),
    EXECUTION_FAILED("ExecutionFailed"),
    EXECUTION_TIMED_OUT("ExecutionTimedOut"),
    EXECUTION_STOPPED("ExecutionStopped"),
    CONTEXT_STARTED("ContextStarted"),
    CONTEXT_SUCCEEDED("ContextSucceeded"),
    CONTEXT_FAILED("ContextFailed"),
    WAIT_STARTED("WaitStarted"),
    WAIT_SUCCEEDED("WaitSucceeded"),
    WAIT_CANCELLED("WaitCancelled"),
    STEP_STARTED("StepStarted"),
    STEP_SUCCEEDED("StepSucceeded"),
    STEP_FAILED("StepFailed"),
    CHAINED_INVOKE_STARTED("ChainedInvokeStarted"),
    CHAINED_INVOKE_SUCCEEDED("ChainedInvokeSucceeded"),
    CHAINED_INVOKE_FAILED("ChainedInvokeFailed"),
    CHAINED_INVOKE_TIMED_OUT("ChainedInvokeTimedOut"),
    CHAINED_INVOKE_STOPPED("ChainedInvokeStopped"),
    CALLBACK_STARTED("CallbackStarted"),
    CALLBACK_SUCCEEDED("CallbackSucceeded"),
    CALLBACK_FAILED("CallbackFailed"),
    CALLBACK_TIMED_OUT("CallbackTimedOut"),
    INVOCATION_COMPLETED("InvocationCompleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
    }
}

