/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.StackTraceEntriesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorObject> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ErrorObject.getter(ErrorObject::errorMessage)).setter(ErrorObject.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorType").getter(ErrorObject.getter(ErrorObject::errorType)).setter(ErrorObject.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorType").build()}).build();
    private static final SdkField<String> ERROR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorData").getter(ErrorObject.getter(ErrorObject::errorData)).setter(ErrorObject.setter(Builder::errorData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorData").build()}).build();
    private static final SdkField<List<String>> STACK_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackTrace").getter(ErrorObject.getter(ErrorObject::stackTrace)).setter(ErrorObject.setter(Builder::stackTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackTrace").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, ERROR_TYPE_FIELD, ERROR_DATA_FIELD, STACK_TRACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ErrorObject.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String errorType;
    private final String errorData;
    private final List<String> stackTrace;

    private ErrorObject(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
        this.errorData = builder.errorData;
        this.stackTrace = builder.stackTrace;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String errorType() {
        return this.errorType;
    }

    public final String errorData() {
        return this.errorData;
    }

    public final boolean hasStackTrace() {
        return this.stackTrace != null && !(this.stackTrace instanceof SdkAutoConstructList);
    }

    public final List<String> stackTrace() {
        return this.stackTrace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackTrace() ? this.stackTrace() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorObject)) {
            return false;
        }
        ErrorObject other = (ErrorObject)obj;
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorType(), other.errorType()) && Objects.equals(this.errorData(), other.errorData()) && this.hasStackTrace() == other.hasStackTrace() && Objects.equals(this.stackTrace(), other.stackTrace());
    }

    public final String toString() {
        return ToString.builder((String)"ErrorObject").add("ErrorMessage", (Object)(this.errorMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorType", (Object)(this.errorType() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorData", (Object)(this.errorData() == null ? null : "*** Sensitive Data Redacted ***")).add("StackTrace", (Object)(this.stackTrace() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorType": {
                return Optional.ofNullable(clazz.cast(this.errorType()));
            }
            case "ErrorData": {
                return Optional.ofNullable(clazz.cast(this.errorData()));
            }
            case "StackTrace": {
                return Optional.ofNullable(clazz.cast(this.stackTrace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ErrorType", ERROR_TYPE_FIELD);
        map.put("ErrorData", ERROR_DATA_FIELD);
        map.put("StackTrace", STACK_TRACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorObject, T> g) {
        return obj -> g.apply((ErrorObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorMessage;
        private String errorType;
        private String errorData;
        private List<String> stackTrace = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorObject model) {
            this.errorMessage(model.errorMessage);
            this.errorType(model.errorType);
            this.errorData(model.errorData);
            this.stackTrace(model.stackTrace);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getErrorData() {
            return this.errorData;
        }

        public final void setErrorData(String errorData) {
            this.errorData = errorData;
        }

        @Override
        public final Builder errorData(String errorData) {
            this.errorData = errorData;
            return this;
        }

        public final Collection<String> getStackTrace() {
            if (this.stackTrace instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackTrace;
        }

        public final void setStackTrace(Collection<String> stackTrace) {
            this.stackTrace = StackTraceEntriesCopier.copy(stackTrace);
        }

        @Override
        public final Builder stackTrace(Collection<String> stackTrace) {
            this.stackTrace = StackTraceEntriesCopier.copy(stackTrace);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackTrace(String ... stackTrace) {
            this.stackTrace(Arrays.asList(stackTrace));
            return this;
        }

        public ErrorObject build() {
            return new ErrorObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorObject> {
        public Builder errorMessage(String var1);

        public Builder errorType(String var1);

        public Builder errorData(String var1);

        public Builder stackTrace(Collection<String> var1);

        public Builder stackTrace(String ... var1);
    }
}

