/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaManagedInstancesCapacityProviderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaManagedInstancesCapacityProviderConfig> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityProviderArn").getter(LambdaManagedInstancesCapacityProviderConfig.getter(LambdaManagedInstancesCapacityProviderConfig::capacityProviderArn)).setter(LambdaManagedInstancesCapacityProviderConfig.setter(Builder::capacityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderArn").build()}).build();
    private static final SdkField<Integer> PER_EXECUTION_ENVIRONMENT_MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerExecutionEnvironmentMaxConcurrency").getter(LambdaManagedInstancesCapacityProviderConfig.getter(LambdaManagedInstancesCapacityProviderConfig::perExecutionEnvironmentMaxConcurrency)).setter(LambdaManagedInstancesCapacityProviderConfig.setter(Builder::perExecutionEnvironmentMaxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerExecutionEnvironmentMaxConcurrency").build()}).build();
    private static final SdkField<Double> EXECUTION_ENVIRONMENT_MEMORY_GI_B_PER_V_CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ExecutionEnvironmentMemoryGiBPerVCpu").getter(LambdaManagedInstancesCapacityProviderConfig.getter(LambdaManagedInstancesCapacityProviderConfig::executionEnvironmentMemoryGiBPerVCpu)).setter(LambdaManagedInstancesCapacityProviderConfig.setter(Builder::executionEnvironmentMemoryGiBPerVCpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEnvironmentMemoryGiBPerVCpu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD, PER_EXECUTION_ENVIRONMENT_MAX_CONCURRENCY_FIELD, EXECUTION_ENVIRONMENT_MEMORY_GI_B_PER_V_CPU_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaManagedInstancesCapacityProviderConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityProviderArn;
    private final Integer perExecutionEnvironmentMaxConcurrency;
    private final Double executionEnvironmentMemoryGiBPerVCpu;

    private LambdaManagedInstancesCapacityProviderConfig(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.perExecutionEnvironmentMaxConcurrency = builder.perExecutionEnvironmentMaxConcurrency;
        this.executionEnvironmentMemoryGiBPerVCpu = builder.executionEnvironmentMemoryGiBPerVCpu;
    }

    public final String capacityProviderArn() {
        return this.capacityProviderArn;
    }

    public final Integer perExecutionEnvironmentMaxConcurrency() {
        return this.perExecutionEnvironmentMaxConcurrency;
    }

    public final Double executionEnvironmentMemoryGiBPerVCpu() {
        return this.executionEnvironmentMemoryGiBPerVCpu;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.perExecutionEnvironmentMaxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEnvironmentMemoryGiBPerVCpu());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaManagedInstancesCapacityProviderConfig)) {
            return false;
        }
        LambdaManagedInstancesCapacityProviderConfig other = (LambdaManagedInstancesCapacityProviderConfig)obj;
        return Objects.equals(this.capacityProviderArn(), other.capacityProviderArn()) && Objects.equals(this.perExecutionEnvironmentMaxConcurrency(), other.perExecutionEnvironmentMaxConcurrency()) && Objects.equals(this.executionEnvironmentMemoryGiBPerVCpu(), other.executionEnvironmentMemoryGiBPerVCpu());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaManagedInstancesCapacityProviderConfig").add("CapacityProviderArn", (Object)this.capacityProviderArn()).add("PerExecutionEnvironmentMaxConcurrency", (Object)this.perExecutionEnvironmentMaxConcurrency()).add("ExecutionEnvironmentMemoryGiBPerVCpu", (Object)this.executionEnvironmentMemoryGiBPerVCpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderArn()));
            }
            case "PerExecutionEnvironmentMaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.perExecutionEnvironmentMaxConcurrency()));
            }
            case "ExecutionEnvironmentMemoryGiBPerVCpu": {
                return Optional.ofNullable(clazz.cast(this.executionEnvironmentMemoryGiBPerVCpu()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
        map.put("PerExecutionEnvironmentMaxConcurrency", PER_EXECUTION_ENVIRONMENT_MAX_CONCURRENCY_FIELD);
        map.put("ExecutionEnvironmentMemoryGiBPerVCpu", EXECUTION_ENVIRONMENT_MEMORY_GI_B_PER_V_CPU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaManagedInstancesCapacityProviderConfig, T> g) {
        return obj -> g.apply((LambdaManagedInstancesCapacityProviderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityProviderArn;
        private Integer perExecutionEnvironmentMaxConcurrency;
        private Double executionEnvironmentMemoryGiBPerVCpu;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaManagedInstancesCapacityProviderConfig model) {
            this.capacityProviderArn(model.capacityProviderArn);
            this.perExecutionEnvironmentMaxConcurrency(model.perExecutionEnvironmentMaxConcurrency);
            this.executionEnvironmentMemoryGiBPerVCpu(model.executionEnvironmentMemoryGiBPerVCpu);
        }

        public final String getCapacityProviderArn() {
            return this.capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final Integer getPerExecutionEnvironmentMaxConcurrency() {
            return this.perExecutionEnvironmentMaxConcurrency;
        }

        public final void setPerExecutionEnvironmentMaxConcurrency(Integer perExecutionEnvironmentMaxConcurrency) {
            this.perExecutionEnvironmentMaxConcurrency = perExecutionEnvironmentMaxConcurrency;
        }

        @Override
        public final Builder perExecutionEnvironmentMaxConcurrency(Integer perExecutionEnvironmentMaxConcurrency) {
            this.perExecutionEnvironmentMaxConcurrency = perExecutionEnvironmentMaxConcurrency;
            return this;
        }

        public final Double getExecutionEnvironmentMemoryGiBPerVCpu() {
            return this.executionEnvironmentMemoryGiBPerVCpu;
        }

        public final void setExecutionEnvironmentMemoryGiBPerVCpu(Double executionEnvironmentMemoryGiBPerVCpu) {
            this.executionEnvironmentMemoryGiBPerVCpu = executionEnvironmentMemoryGiBPerVCpu;
        }

        @Override
        public final Builder executionEnvironmentMemoryGiBPerVCpu(Double executionEnvironmentMemoryGiBPerVCpu) {
            this.executionEnvironmentMemoryGiBPerVCpu = executionEnvironmentMemoryGiBPerVCpu;
            return this;
        }

        public LambdaManagedInstancesCapacityProviderConfig build() {
            return new LambdaManagedInstancesCapacityProviderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaManagedInstancesCapacityProviderConfig> {
        public Builder capacityProviderArn(String var1);

        public Builder perExecutionEnvironmentMaxConcurrency(Integer var1);

        public Builder executionEnvironmentMemoryGiBPerVCpu(Double var1);
    }
}

