/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.ExecutionStatus;
import software.amazon.awssdk.services.lambda.model.ExecutionStatusListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDurableExecutionsByFunctionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, ListDurableExecutionsByFunctionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::functionName)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::qualifier)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionName").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::durableExecutionName)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::durableExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DurableExecutionName").build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statuses").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::statusesAsStrings)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAfter").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::startedAfter)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::startedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartedAfter").build()}).build();
    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedBefore").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::startedBefore)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::startedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartedBefore").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReverseOrder").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::reverseOrder)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ReverseOrder").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::marker)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListDurableExecutionsByFunctionRequest.getter(ListDurableExecutionsByFunctionRequest::maxItems)).setter(ListDurableExecutionsByFunctionRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, QUALIFIER_FIELD, DURABLE_EXECUTION_NAME_FIELD, STATUSES_FIELD, STARTED_AFTER_FIELD, STARTED_BEFORE_FIELD, REVERSE_ORDER_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDurableExecutionsByFunctionRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String qualifier;
    private final String durableExecutionName;
    private final List<String> statuses;
    private final Instant startedAfter;
    private final Instant startedBefore;
    private final Boolean reverseOrder;
    private final String marker;
    private final Integer maxItems;

    private ListDurableExecutionsByFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.durableExecutionName = builder.durableExecutionName;
        this.statuses = builder.statuses;
        this.startedAfter = builder.startedAfter;
        this.startedBefore = builder.startedBefore;
        this.reverseOrder = builder.reverseOrder;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final String durableExecutionName() {
        return this.durableExecutionName;
    }

    public final List<ExecutionStatus> statuses() {
        return ExecutionStatusListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final Instant startedAfter() {
        return this.startedAfter;
    }

    public final Instant startedBefore() {
        return this.startedBefore;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDurableExecutionsByFunctionRequest)) {
            return false;
        }
        ListDurableExecutionsByFunctionRequest other = (ListDurableExecutionsByFunctionRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.durableExecutionName(), other.durableExecutionName()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && Objects.equals(this.startedAfter(), other.startedAfter()) && Objects.equals(this.startedBefore(), other.startedBefore()) && Objects.equals(this.reverseOrder(), other.reverseOrder()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListDurableExecutionsByFunctionRequest").add("FunctionName", (Object)this.functionName()).add("Qualifier", (Object)this.qualifier()).add("DurableExecutionName", (Object)this.durableExecutionName()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("StartedAfter", (Object)this.startedAfter()).add("StartedBefore", (Object)this.startedBefore()).add("ReverseOrder", (Object)this.reverseOrder()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "DurableExecutionName": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionName()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "StartedAfter": {
                return Optional.ofNullable(clazz.cast(this.startedAfter()));
            }
            case "StartedBefore": {
                return Optional.ofNullable(clazz.cast(this.startedBefore()));
            }
            case "ReverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("DurableExecutionName", DURABLE_EXECUTION_NAME_FIELD);
        map.put("Statuses", STATUSES_FIELD);
        map.put("StartedAfter", STARTED_AFTER_FIELD);
        map.put("StartedBefore", STARTED_BEFORE_FIELD);
        map.put("ReverseOrder", REVERSE_ORDER_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDurableExecutionsByFunctionRequest, T> g) {
        return obj -> g.apply((ListDurableExecutionsByFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String qualifier;
        private String durableExecutionName;
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private Instant startedAfter;
        private Instant startedBefore;
        private Boolean reverseOrder;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDurableExecutionsByFunctionRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.qualifier(model.qualifier);
            this.durableExecutionName(model.durableExecutionName);
            this.statusesWithStrings(model.statuses);
            this.startedAfter(model.startedAfter);
            this.startedBefore(model.startedBefore);
            this.reverseOrder(model.reverseOrder);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getDurableExecutionName() {
            return this.durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ExecutionStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ExecutionStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ExecutionStatus> statuses) {
            this.statuses = ExecutionStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ExecutionStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Instant getStartedAfter() {
            return this.startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public final Instant getStartedBefore() {
            return this.startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDurableExecutionsByFunctionRequest build() {
            return new ListDurableExecutionsByFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDurableExecutionsByFunctionRequest> {
        public Builder functionName(String var1);

        public Builder qualifier(String var1);

        public Builder durableExecutionName(String var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<ExecutionStatus> var1);

        public Builder statuses(ExecutionStatus ... var1);

        public Builder startedAfter(Instant var1);

        public Builder startedBefore(Instant var1);

        public Builder reverseOrder(Boolean var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

