/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.FunctionScalingConfig;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFunctionScalingConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetFunctionScalingConfigResponse> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(GetFunctionScalingConfigResponse.getter(GetFunctionScalingConfigResponse::functionArn)).setter(GetFunctionScalingConfigResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<FunctionScalingConfig> APPLIED_FUNCTION_SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppliedFunctionScalingConfig").getter(GetFunctionScalingConfigResponse.getter(GetFunctionScalingConfigResponse::appliedFunctionScalingConfig)).setter(GetFunctionScalingConfigResponse.setter(Builder::appliedFunctionScalingConfig)).constructor(FunctionScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedFunctionScalingConfig").build()}).build();
    private static final SdkField<FunctionScalingConfig> REQUESTED_FUNCTION_SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestedFunctionScalingConfig").getter(GetFunctionScalingConfigResponse.getter(GetFunctionScalingConfigResponse::requestedFunctionScalingConfig)).setter(GetFunctionScalingConfigResponse.setter(Builder::requestedFunctionScalingConfig)).constructor(FunctionScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedFunctionScalingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, APPLIED_FUNCTION_SCALING_CONFIG_FIELD, REQUESTED_FUNCTION_SCALING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFunctionScalingConfigResponse.memberNameToFieldInitializer();
    private final String functionArn;
    private final FunctionScalingConfig appliedFunctionScalingConfig;
    private final FunctionScalingConfig requestedFunctionScalingConfig;

    private GetFunctionScalingConfigResponse(BuilderImpl builder) {
        super(builder);
        this.functionArn = builder.functionArn;
        this.appliedFunctionScalingConfig = builder.appliedFunctionScalingConfig;
        this.requestedFunctionScalingConfig = builder.requestedFunctionScalingConfig;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final FunctionScalingConfig appliedFunctionScalingConfig() {
        return this.appliedFunctionScalingConfig;
    }

    public final FunctionScalingConfig requestedFunctionScalingConfig() {
        return this.requestedFunctionScalingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedFunctionScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedFunctionScalingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionScalingConfigResponse)) {
            return false;
        }
        GetFunctionScalingConfigResponse other = (GetFunctionScalingConfigResponse)((Object)obj);
        return Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.appliedFunctionScalingConfig(), other.appliedFunctionScalingConfig()) && Objects.equals(this.requestedFunctionScalingConfig(), other.requestedFunctionScalingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetFunctionScalingConfigResponse").add("FunctionArn", (Object)this.functionArn()).add("AppliedFunctionScalingConfig", (Object)this.appliedFunctionScalingConfig()).add("RequestedFunctionScalingConfig", (Object)this.requestedFunctionScalingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "AppliedFunctionScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.appliedFunctionScalingConfig()));
            }
            case "RequestedFunctionScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.requestedFunctionScalingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("AppliedFunctionScalingConfig", APPLIED_FUNCTION_SCALING_CONFIG_FIELD);
        map.put("RequestedFunctionScalingConfig", REQUESTED_FUNCTION_SCALING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionScalingConfigResponse, T> g) {
        return obj -> g.apply((GetFunctionScalingConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String functionArn;
        private FunctionScalingConfig appliedFunctionScalingConfig;
        private FunctionScalingConfig requestedFunctionScalingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionScalingConfigResponse model) {
            super(model);
            this.functionArn(model.functionArn);
            this.appliedFunctionScalingConfig(model.appliedFunctionScalingConfig);
            this.requestedFunctionScalingConfig(model.requestedFunctionScalingConfig);
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final FunctionScalingConfig.Builder getAppliedFunctionScalingConfig() {
            return this.appliedFunctionScalingConfig != null ? this.appliedFunctionScalingConfig.toBuilder() : null;
        }

        public final void setAppliedFunctionScalingConfig(FunctionScalingConfig.BuilderImpl appliedFunctionScalingConfig) {
            this.appliedFunctionScalingConfig = appliedFunctionScalingConfig != null ? appliedFunctionScalingConfig.build() : null;
        }

        @Override
        public final Builder appliedFunctionScalingConfig(FunctionScalingConfig appliedFunctionScalingConfig) {
            this.appliedFunctionScalingConfig = appliedFunctionScalingConfig;
            return this;
        }

        public final FunctionScalingConfig.Builder getRequestedFunctionScalingConfig() {
            return this.requestedFunctionScalingConfig != null ? this.requestedFunctionScalingConfig.toBuilder() : null;
        }

        public final void setRequestedFunctionScalingConfig(FunctionScalingConfig.BuilderImpl requestedFunctionScalingConfig) {
            this.requestedFunctionScalingConfig = requestedFunctionScalingConfig != null ? requestedFunctionScalingConfig.build() : null;
        }

        @Override
        public final Builder requestedFunctionScalingConfig(FunctionScalingConfig requestedFunctionScalingConfig) {
            this.requestedFunctionScalingConfig = requestedFunctionScalingConfig;
            return this;
        }

        @Override
        public GetFunctionScalingConfigResponse build() {
            return new GetFunctionScalingConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFunctionScalingConfigResponse> {
        public Builder functionArn(String var1);

        public Builder appliedFunctionScalingConfig(FunctionScalingConfig var1);

        default public Builder appliedFunctionScalingConfig(Consumer<FunctionScalingConfig.Builder> appliedFunctionScalingConfig) {
            return this.appliedFunctionScalingConfig((FunctionScalingConfig)((FunctionScalingConfig.Builder)FunctionScalingConfig.builder().applyMutation(appliedFunctionScalingConfig)).build());
        }

        public Builder requestedFunctionScalingConfig(FunctionScalingConfig var1);

        default public Builder requestedFunctionScalingConfig(Consumer<FunctionScalingConfig.Builder> requestedFunctionScalingConfig) {
            return this.requestedFunctionScalingConfig((FunctionScalingConfig)((FunctionScalingConfig.Builder)FunctionScalingConfig.builder().applyMutation(requestedFunctionScalingConfig)).build());
        }
    }
}

