/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CapacityProviderScalingConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCapacityProviderRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, UpdateCapacityProviderRequest> {
    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityProviderName").getter(UpdateCapacityProviderRequest.getter(UpdateCapacityProviderRequest::capacityProviderName)).setter(UpdateCapacityProviderRequest.setter(Builder::capacityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CapacityProviderName").build()}).build();
    private static final SdkField<CapacityProviderScalingConfig> CAPACITY_PROVIDER_SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityProviderScalingConfig").getter(UpdateCapacityProviderRequest.getter(UpdateCapacityProviderRequest::capacityProviderScalingConfig)).setter(UpdateCapacityProviderRequest.setter(Builder::capacityProviderScalingConfig)).constructor(CapacityProviderScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderScalingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_NAME_FIELD, CAPACITY_PROVIDER_SCALING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCapacityProviderRequest.memberNameToFieldInitializer();
    private final String capacityProviderName;
    private final CapacityProviderScalingConfig capacityProviderScalingConfig;

    private UpdateCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviderName = builder.capacityProviderName;
        this.capacityProviderScalingConfig = builder.capacityProviderScalingConfig;
    }

    public final String capacityProviderName() {
        return this.capacityProviderName;
    }

    public final CapacityProviderScalingConfig capacityProviderScalingConfig() {
        return this.capacityProviderScalingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderScalingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapacityProviderRequest)) {
            return false;
        }
        UpdateCapacityProviderRequest other = (UpdateCapacityProviderRequest)((Object)obj);
        return Objects.equals(this.capacityProviderName(), other.capacityProviderName()) && Objects.equals(this.capacityProviderScalingConfig(), other.capacityProviderScalingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCapacityProviderRequest").add("CapacityProviderName", (Object)this.capacityProviderName()).add("CapacityProviderScalingConfig", (Object)this.capacityProviderScalingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviderName": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderName()));
            }
            case "CapacityProviderScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderScalingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityProviderName", CAPACITY_PROVIDER_NAME_FIELD);
        map.put("CapacityProviderScalingConfig", CAPACITY_PROVIDER_SCALING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapacityProviderRequest, T> g) {
        return obj -> g.apply((UpdateCapacityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String capacityProviderName;
        private CapacityProviderScalingConfig capacityProviderScalingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapacityProviderRequest model) {
            super(model);
            this.capacityProviderName(model.capacityProviderName);
            this.capacityProviderScalingConfig(model.capacityProviderScalingConfig);
        }

        public final String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final CapacityProviderScalingConfig.Builder getCapacityProviderScalingConfig() {
            return this.capacityProviderScalingConfig != null ? this.capacityProviderScalingConfig.toBuilder() : null;
        }

        public final void setCapacityProviderScalingConfig(CapacityProviderScalingConfig.BuilderImpl capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig != null ? capacityProviderScalingConfig.build() : null;
        }

        @Override
        public final Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapacityProviderRequest build() {
            return new UpdateCapacityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCapacityProviderRequest> {
        public Builder capacityProviderName(String var1);

        public Builder capacityProviderScalingConfig(CapacityProviderScalingConfig var1);

        default public Builder capacityProviderScalingConfig(Consumer<CapacityProviderScalingConfig.Builder> capacityProviderScalingConfig) {
            return this.capacityProviderScalingConfig((CapacityProviderScalingConfig)((CapacityProviderScalingConfig.Builder)CapacityProviderScalingConfig.builder().applyMutation(capacityProviderScalingConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

