/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CallbackFailedDetails;
import software.amazon.awssdk.services.lambda.model.CallbackStartedDetails;
import software.amazon.awssdk.services.lambda.model.CallbackSucceededDetails;
import software.amazon.awssdk.services.lambda.model.CallbackTimedOutDetails;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeFailedDetails;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeStartedDetails;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeStoppedDetails;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeSucceededDetails;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeTimedOutDetails;
import software.amazon.awssdk.services.lambda.model.ContextFailedDetails;
import software.amazon.awssdk.services.lambda.model.ContextStartedDetails;
import software.amazon.awssdk.services.lambda.model.ContextSucceededDetails;
import software.amazon.awssdk.services.lambda.model.EventType;
import software.amazon.awssdk.services.lambda.model.ExecutionFailedDetails;
import software.amazon.awssdk.services.lambda.model.ExecutionStartedDetails;
import software.amazon.awssdk.services.lambda.model.ExecutionStoppedDetails;
import software.amazon.awssdk.services.lambda.model.ExecutionSucceededDetails;
import software.amazon.awssdk.services.lambda.model.ExecutionTimedOutDetails;
import software.amazon.awssdk.services.lambda.model.InvocationCompletedDetails;
import software.amazon.awssdk.services.lambda.model.StepFailedDetails;
import software.amazon.awssdk.services.lambda.model.StepStartedDetails;
import software.amazon.awssdk.services.lambda.model.StepSucceededDetails;
import software.amazon.awssdk.services.lambda.model.WaitCancelledDetails;
import software.amazon.awssdk.services.lambda.model.WaitStartedDetails;
import software.amazon.awssdk.services.lambda.model.WaitSucceededDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(Event.getter(Event::eventTypeAsString)).setter(Event.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubType").getter(Event.getter(Event::subType)).setter(Event.setter(Builder::subType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()}).build();
    private static final SdkField<Integer> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EventId").getter(Event.getter(Event::eventId)).setter(Event.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Event.getter(Event::id)).setter(Event.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Event.getter(Event::name)).setter(Event.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTimestamp").getter(Event.getter(Event::eventTimestamp)).setter(Event.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimestamp").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentId").getter(Event.getter(Event::parentId)).setter(Event.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<ExecutionStartedDetails> EXECUTION_STARTED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionStartedDetails").getter(Event.getter(Event::executionStartedDetails)).setter(Event.setter(Builder::executionStartedDetails)).constructor(ExecutionStartedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartedDetails").build()}).build();
    private static final SdkField<ExecutionSucceededDetails> EXECUTION_SUCCEEDED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionSucceededDetails").getter(Event.getter(Event::executionSucceededDetails)).setter(Event.setter(Builder::executionSucceededDetails)).constructor(ExecutionSucceededDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSucceededDetails").build()}).build();
    private static final SdkField<ExecutionFailedDetails> EXECUTION_FAILED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionFailedDetails").getter(Event.getter(Event::executionFailedDetails)).setter(Event.setter(Builder::executionFailedDetails)).constructor(ExecutionFailedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionFailedDetails").build()}).build();
    private static final SdkField<ExecutionTimedOutDetails> EXECUTION_TIMED_OUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionTimedOutDetails").getter(Event.getter(Event::executionTimedOutDetails)).setter(Event.setter(Builder::executionTimedOutDetails)).constructor(ExecutionTimedOutDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimedOutDetails").build()}).build();
    private static final SdkField<ExecutionStoppedDetails> EXECUTION_STOPPED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionStoppedDetails").getter(Event.getter(Event::executionStoppedDetails)).setter(Event.setter(Builder::executionStoppedDetails)).constructor(ExecutionStoppedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStoppedDetails").build()}).build();
    private static final SdkField<ContextStartedDetails> CONTEXT_STARTED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextStartedDetails").getter(Event.getter(Event::contextStartedDetails)).setter(Event.setter(Builder::contextStartedDetails)).constructor(ContextStartedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextStartedDetails").build()}).build();
    private static final SdkField<ContextSucceededDetails> CONTEXT_SUCCEEDED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextSucceededDetails").getter(Event.getter(Event::contextSucceededDetails)).setter(Event.setter(Builder::contextSucceededDetails)).constructor(ContextSucceededDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextSucceededDetails").build()}).build();
    private static final SdkField<ContextFailedDetails> CONTEXT_FAILED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextFailedDetails").getter(Event.getter(Event::contextFailedDetails)).setter(Event.setter(Builder::contextFailedDetails)).constructor(ContextFailedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextFailedDetails").build()}).build();
    private static final SdkField<WaitStartedDetails> WAIT_STARTED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WaitStartedDetails").getter(Event.getter(Event::waitStartedDetails)).setter(Event.setter(Builder::waitStartedDetails)).constructor(WaitStartedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitStartedDetails").build()}).build();
    private static final SdkField<WaitSucceededDetails> WAIT_SUCCEEDED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WaitSucceededDetails").getter(Event.getter(Event::waitSucceededDetails)).setter(Event.setter(Builder::waitSucceededDetails)).constructor(WaitSucceededDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitSucceededDetails").build()}).build();
    private static final SdkField<WaitCancelledDetails> WAIT_CANCELLED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WaitCancelledDetails").getter(Event.getter(Event::waitCancelledDetails)).setter(Event.setter(Builder::waitCancelledDetails)).constructor(WaitCancelledDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitCancelledDetails").build()}).build();
    private static final SdkField<StepStartedDetails> STEP_STARTED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepStartedDetails").getter(Event.getter(Event::stepStartedDetails)).setter(Event.setter(Builder::stepStartedDetails)).constructor(StepStartedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStartedDetails").build()}).build();
    private static final SdkField<StepSucceededDetails> STEP_SUCCEEDED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepSucceededDetails").getter(Event.getter(Event::stepSucceededDetails)).setter(Event.setter(Builder::stepSucceededDetails)).constructor(StepSucceededDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepSucceededDetails").build()}).build();
    private static final SdkField<StepFailedDetails> STEP_FAILED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepFailedDetails").getter(Event.getter(Event::stepFailedDetails)).setter(Event.setter(Builder::stepFailedDetails)).constructor(StepFailedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepFailedDetails").build()}).build();
    private static final SdkField<ChainedInvokeStartedDetails> CHAINED_INVOKE_STARTED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeStartedDetails").getter(Event.getter(Event::chainedInvokeStartedDetails)).setter(Event.setter(Builder::chainedInvokeStartedDetails)).constructor(ChainedInvokeStartedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeStartedDetails").build()}).build();
    private static final SdkField<ChainedInvokeSucceededDetails> CHAINED_INVOKE_SUCCEEDED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeSucceededDetails").getter(Event.getter(Event::chainedInvokeSucceededDetails)).setter(Event.setter(Builder::chainedInvokeSucceededDetails)).constructor(ChainedInvokeSucceededDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeSucceededDetails").build()}).build();
    private static final SdkField<ChainedInvokeFailedDetails> CHAINED_INVOKE_FAILED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeFailedDetails").getter(Event.getter(Event::chainedInvokeFailedDetails)).setter(Event.setter(Builder::chainedInvokeFailedDetails)).constructor(ChainedInvokeFailedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeFailedDetails").build()}).build();
    private static final SdkField<ChainedInvokeTimedOutDetails> CHAINED_INVOKE_TIMED_OUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeTimedOutDetails").getter(Event.getter(Event::chainedInvokeTimedOutDetails)).setter(Event.setter(Builder::chainedInvokeTimedOutDetails)).constructor(ChainedInvokeTimedOutDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeTimedOutDetails").build()}).build();
    private static final SdkField<ChainedInvokeStoppedDetails> CHAINED_INVOKE_STOPPED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeStoppedDetails").getter(Event.getter(Event::chainedInvokeStoppedDetails)).setter(Event.setter(Builder::chainedInvokeStoppedDetails)).constructor(ChainedInvokeStoppedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeStoppedDetails").build()}).build();
    private static final SdkField<CallbackStartedDetails> CALLBACK_STARTED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallbackStartedDetails").getter(Event.getter(Event::callbackStartedDetails)).setter(Event.setter(Builder::callbackStartedDetails)).constructor(CallbackStartedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackStartedDetails").build()}).build();
    private static final SdkField<CallbackSucceededDetails> CALLBACK_SUCCEEDED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallbackSucceededDetails").getter(Event.getter(Event::callbackSucceededDetails)).setter(Event.setter(Builder::callbackSucceededDetails)).constructor(CallbackSucceededDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackSucceededDetails").build()}).build();
    private static final SdkField<CallbackFailedDetails> CALLBACK_FAILED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallbackFailedDetails").getter(Event.getter(Event::callbackFailedDetails)).setter(Event.setter(Builder::callbackFailedDetails)).constructor(CallbackFailedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackFailedDetails").build()}).build();
    private static final SdkField<CallbackTimedOutDetails> CALLBACK_TIMED_OUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallbackTimedOutDetails").getter(Event.getter(Event::callbackTimedOutDetails)).setter(Event.setter(Builder::callbackTimedOutDetails)).constructor(CallbackTimedOutDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackTimedOutDetails").build()}).build();
    private static final SdkField<InvocationCompletedDetails> INVOCATION_COMPLETED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvocationCompletedDetails").getter(Event.getter(Event::invocationCompletedDetails)).setter(Event.setter(Builder::invocationCompletedDetails)).constructor(InvocationCompletedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationCompletedDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, SUB_TYPE_FIELD, EVENT_ID_FIELD, ID_FIELD, NAME_FIELD, EVENT_TIMESTAMP_FIELD, PARENT_ID_FIELD, EXECUTION_STARTED_DETAILS_FIELD, EXECUTION_SUCCEEDED_DETAILS_FIELD, EXECUTION_FAILED_DETAILS_FIELD, EXECUTION_TIMED_OUT_DETAILS_FIELD, EXECUTION_STOPPED_DETAILS_FIELD, CONTEXT_STARTED_DETAILS_FIELD, CONTEXT_SUCCEEDED_DETAILS_FIELD, CONTEXT_FAILED_DETAILS_FIELD, WAIT_STARTED_DETAILS_FIELD, WAIT_SUCCEEDED_DETAILS_FIELD, WAIT_CANCELLED_DETAILS_FIELD, STEP_STARTED_DETAILS_FIELD, STEP_SUCCEEDED_DETAILS_FIELD, STEP_FAILED_DETAILS_FIELD, CHAINED_INVOKE_STARTED_DETAILS_FIELD, CHAINED_INVOKE_SUCCEEDED_DETAILS_FIELD, CHAINED_INVOKE_FAILED_DETAILS_FIELD, CHAINED_INVOKE_TIMED_OUT_DETAILS_FIELD, CHAINED_INVOKE_STOPPED_DETAILS_FIELD, CALLBACK_STARTED_DETAILS_FIELD, CALLBACK_SUCCEEDED_DETAILS_FIELD, CALLBACK_FAILED_DETAILS_FIELD, CALLBACK_TIMED_OUT_DETAILS_FIELD, INVOCATION_COMPLETED_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Event.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final String subType;
    private final Integer eventId;
    private final String id;
    private final String name;
    private final Instant eventTimestamp;
    private final String parentId;
    private final ExecutionStartedDetails executionStartedDetails;
    private final ExecutionSucceededDetails executionSucceededDetails;
    private final ExecutionFailedDetails executionFailedDetails;
    private final ExecutionTimedOutDetails executionTimedOutDetails;
    private final ExecutionStoppedDetails executionStoppedDetails;
    private final ContextStartedDetails contextStartedDetails;
    private final ContextSucceededDetails contextSucceededDetails;
    private final ContextFailedDetails contextFailedDetails;
    private final WaitStartedDetails waitStartedDetails;
    private final WaitSucceededDetails waitSucceededDetails;
    private final WaitCancelledDetails waitCancelledDetails;
    private final StepStartedDetails stepStartedDetails;
    private final StepSucceededDetails stepSucceededDetails;
    private final StepFailedDetails stepFailedDetails;
    private final ChainedInvokeStartedDetails chainedInvokeStartedDetails;
    private final ChainedInvokeSucceededDetails chainedInvokeSucceededDetails;
    private final ChainedInvokeFailedDetails chainedInvokeFailedDetails;
    private final ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails;
    private final ChainedInvokeStoppedDetails chainedInvokeStoppedDetails;
    private final CallbackStartedDetails callbackStartedDetails;
    private final CallbackSucceededDetails callbackSucceededDetails;
    private final CallbackFailedDetails callbackFailedDetails;
    private final CallbackTimedOutDetails callbackTimedOutDetails;
    private final InvocationCompletedDetails invocationCompletedDetails;

    private Event(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.subType = builder.subType;
        this.eventId = builder.eventId;
        this.id = builder.id;
        this.name = builder.name;
        this.eventTimestamp = builder.eventTimestamp;
        this.parentId = builder.parentId;
        this.executionStartedDetails = builder.executionStartedDetails;
        this.executionSucceededDetails = builder.executionSucceededDetails;
        this.executionFailedDetails = builder.executionFailedDetails;
        this.executionTimedOutDetails = builder.executionTimedOutDetails;
        this.executionStoppedDetails = builder.executionStoppedDetails;
        this.contextStartedDetails = builder.contextStartedDetails;
        this.contextSucceededDetails = builder.contextSucceededDetails;
        this.contextFailedDetails = builder.contextFailedDetails;
        this.waitStartedDetails = builder.waitStartedDetails;
        this.waitSucceededDetails = builder.waitSucceededDetails;
        this.waitCancelledDetails = builder.waitCancelledDetails;
        this.stepStartedDetails = builder.stepStartedDetails;
        this.stepSucceededDetails = builder.stepSucceededDetails;
        this.stepFailedDetails = builder.stepFailedDetails;
        this.chainedInvokeStartedDetails = builder.chainedInvokeStartedDetails;
        this.chainedInvokeSucceededDetails = builder.chainedInvokeSucceededDetails;
        this.chainedInvokeFailedDetails = builder.chainedInvokeFailedDetails;
        this.chainedInvokeTimedOutDetails = builder.chainedInvokeTimedOutDetails;
        this.chainedInvokeStoppedDetails = builder.chainedInvokeStoppedDetails;
        this.callbackStartedDetails = builder.callbackStartedDetails;
        this.callbackSucceededDetails = builder.callbackSucceededDetails;
        this.callbackFailedDetails = builder.callbackFailedDetails;
        this.callbackTimedOutDetails = builder.callbackTimedOutDetails;
        this.invocationCompletedDetails = builder.invocationCompletedDetails;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String subType() {
        return this.subType;
    }

    public final Integer eventId() {
        return this.eventId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Instant eventTimestamp() {
        return this.eventTimestamp;
    }

    public final String parentId() {
        return this.parentId;
    }

    public final ExecutionStartedDetails executionStartedDetails() {
        return this.executionStartedDetails;
    }

    public final ExecutionSucceededDetails executionSucceededDetails() {
        return this.executionSucceededDetails;
    }

    public final ExecutionFailedDetails executionFailedDetails() {
        return this.executionFailedDetails;
    }

    public final ExecutionTimedOutDetails executionTimedOutDetails() {
        return this.executionTimedOutDetails;
    }

    public final ExecutionStoppedDetails executionStoppedDetails() {
        return this.executionStoppedDetails;
    }

    public final ContextStartedDetails contextStartedDetails() {
        return this.contextStartedDetails;
    }

    public final ContextSucceededDetails contextSucceededDetails() {
        return this.contextSucceededDetails;
    }

    public final ContextFailedDetails contextFailedDetails() {
        return this.contextFailedDetails;
    }

    public final WaitStartedDetails waitStartedDetails() {
        return this.waitStartedDetails;
    }

    public final WaitSucceededDetails waitSucceededDetails() {
        return this.waitSucceededDetails;
    }

    public final WaitCancelledDetails waitCancelledDetails() {
        return this.waitCancelledDetails;
    }

    public final StepStartedDetails stepStartedDetails() {
        return this.stepStartedDetails;
    }

    public final StepSucceededDetails stepSucceededDetails() {
        return this.stepSucceededDetails;
    }

    public final StepFailedDetails stepFailedDetails() {
        return this.stepFailedDetails;
    }

    public final ChainedInvokeStartedDetails chainedInvokeStartedDetails() {
        return this.chainedInvokeStartedDetails;
    }

    public final ChainedInvokeSucceededDetails chainedInvokeSucceededDetails() {
        return this.chainedInvokeSucceededDetails;
    }

    public final ChainedInvokeFailedDetails chainedInvokeFailedDetails() {
        return this.chainedInvokeFailedDetails;
    }

    public final ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails() {
        return this.chainedInvokeTimedOutDetails;
    }

    public final ChainedInvokeStoppedDetails chainedInvokeStoppedDetails() {
        return this.chainedInvokeStoppedDetails;
    }

    public final CallbackStartedDetails callbackStartedDetails() {
        return this.callbackStartedDetails;
    }

    public final CallbackSucceededDetails callbackSucceededDetails() {
        return this.callbackSucceededDetails;
    }

    public final CallbackFailedDetails callbackFailedDetails() {
        return this.callbackFailedDetails;
    }

    public final CallbackTimedOutDetails callbackTimedOutDetails() {
        return this.callbackTimedOutDetails;
    }

    public final InvocationCompletedDetails invocationCompletedDetails() {
        return this.invocationCompletedDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimedOutDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStoppedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitCancelledDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeTimedOutDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeStoppedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackStartedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackSucceededDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackFailedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackTimedOutDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationCompletedDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.subType(), other.subType()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.executionStartedDetails(), other.executionStartedDetails()) && Objects.equals(this.executionSucceededDetails(), other.executionSucceededDetails()) && Objects.equals(this.executionFailedDetails(), other.executionFailedDetails()) && Objects.equals(this.executionTimedOutDetails(), other.executionTimedOutDetails()) && Objects.equals(this.executionStoppedDetails(), other.executionStoppedDetails()) && Objects.equals(this.contextStartedDetails(), other.contextStartedDetails()) && Objects.equals(this.contextSucceededDetails(), other.contextSucceededDetails()) && Objects.equals(this.contextFailedDetails(), other.contextFailedDetails()) && Objects.equals(this.waitStartedDetails(), other.waitStartedDetails()) && Objects.equals(this.waitSucceededDetails(), other.waitSucceededDetails()) && Objects.equals(this.waitCancelledDetails(), other.waitCancelledDetails()) && Objects.equals(this.stepStartedDetails(), other.stepStartedDetails()) && Objects.equals(this.stepSucceededDetails(), other.stepSucceededDetails()) && Objects.equals(this.stepFailedDetails(), other.stepFailedDetails()) && Objects.equals(this.chainedInvokeStartedDetails(), other.chainedInvokeStartedDetails()) && Objects.equals(this.chainedInvokeSucceededDetails(), other.chainedInvokeSucceededDetails()) && Objects.equals(this.chainedInvokeFailedDetails(), other.chainedInvokeFailedDetails()) && Objects.equals(this.chainedInvokeTimedOutDetails(), other.chainedInvokeTimedOutDetails()) && Objects.equals(this.chainedInvokeStoppedDetails(), other.chainedInvokeStoppedDetails()) && Objects.equals(this.callbackStartedDetails(), other.callbackStartedDetails()) && Objects.equals(this.callbackSucceededDetails(), other.callbackSucceededDetails()) && Objects.equals(this.callbackFailedDetails(), other.callbackFailedDetails()) && Objects.equals(this.callbackTimedOutDetails(), other.callbackTimedOutDetails()) && Objects.equals(this.invocationCompletedDetails(), other.invocationCompletedDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("EventType", (Object)this.eventTypeAsString()).add("SubType", (Object)this.subType()).add("EventId", (Object)this.eventId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("EventTimestamp", (Object)this.eventTimestamp()).add("ParentId", (Object)this.parentId()).add("ExecutionStartedDetails", (Object)this.executionStartedDetails()).add("ExecutionSucceededDetails", (Object)this.executionSucceededDetails()).add("ExecutionFailedDetails", (Object)this.executionFailedDetails()).add("ExecutionTimedOutDetails", (Object)this.executionTimedOutDetails()).add("ExecutionStoppedDetails", (Object)this.executionStoppedDetails()).add("ContextStartedDetails", (Object)this.contextStartedDetails()).add("ContextSucceededDetails", (Object)this.contextSucceededDetails()).add("ContextFailedDetails", (Object)this.contextFailedDetails()).add("WaitStartedDetails", (Object)this.waitStartedDetails()).add("WaitSucceededDetails", (Object)this.waitSucceededDetails()).add("WaitCancelledDetails", (Object)this.waitCancelledDetails()).add("StepStartedDetails", (Object)this.stepStartedDetails()).add("StepSucceededDetails", (Object)this.stepSucceededDetails()).add("StepFailedDetails", (Object)this.stepFailedDetails()).add("ChainedInvokeStartedDetails", (Object)this.chainedInvokeStartedDetails()).add("ChainedInvokeSucceededDetails", (Object)this.chainedInvokeSucceededDetails()).add("ChainedInvokeFailedDetails", (Object)this.chainedInvokeFailedDetails()).add("ChainedInvokeTimedOutDetails", (Object)this.chainedInvokeTimedOutDetails()).add("ChainedInvokeStoppedDetails", (Object)this.chainedInvokeStoppedDetails()).add("CallbackStartedDetails", (Object)this.callbackStartedDetails()).add("CallbackSucceededDetails", (Object)this.callbackSucceededDetails()).add("CallbackFailedDetails", (Object)this.callbackFailedDetails()).add("CallbackTimedOutDetails", (Object)this.callbackTimedOutDetails()).add("InvocationCompletedDetails", (Object)this.invocationCompletedDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "SubType": {
                return Optional.ofNullable(clazz.cast(this.subType()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "ExecutionStartedDetails": {
                return Optional.ofNullable(clazz.cast(this.executionStartedDetails()));
            }
            case "ExecutionSucceededDetails": {
                return Optional.ofNullable(clazz.cast(this.executionSucceededDetails()));
            }
            case "ExecutionFailedDetails": {
                return Optional.ofNullable(clazz.cast(this.executionFailedDetails()));
            }
            case "ExecutionTimedOutDetails": {
                return Optional.ofNullable(clazz.cast(this.executionTimedOutDetails()));
            }
            case "ExecutionStoppedDetails": {
                return Optional.ofNullable(clazz.cast(this.executionStoppedDetails()));
            }
            case "ContextStartedDetails": {
                return Optional.ofNullable(clazz.cast(this.contextStartedDetails()));
            }
            case "ContextSucceededDetails": {
                return Optional.ofNullable(clazz.cast(this.contextSucceededDetails()));
            }
            case "ContextFailedDetails": {
                return Optional.ofNullable(clazz.cast(this.contextFailedDetails()));
            }
            case "WaitStartedDetails": {
                return Optional.ofNullable(clazz.cast(this.waitStartedDetails()));
            }
            case "WaitSucceededDetails": {
                return Optional.ofNullable(clazz.cast(this.waitSucceededDetails()));
            }
            case "WaitCancelledDetails": {
                return Optional.ofNullable(clazz.cast(this.waitCancelledDetails()));
            }
            case "StepStartedDetails": {
                return Optional.ofNullable(clazz.cast(this.stepStartedDetails()));
            }
            case "StepSucceededDetails": {
                return Optional.ofNullable(clazz.cast(this.stepSucceededDetails()));
            }
            case "StepFailedDetails": {
                return Optional.ofNullable(clazz.cast(this.stepFailedDetails()));
            }
            case "ChainedInvokeStartedDetails": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeStartedDetails()));
            }
            case "ChainedInvokeSucceededDetails": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeSucceededDetails()));
            }
            case "ChainedInvokeFailedDetails": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeFailedDetails()));
            }
            case "ChainedInvokeTimedOutDetails": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeTimedOutDetails()));
            }
            case "ChainedInvokeStoppedDetails": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeStoppedDetails()));
            }
            case "CallbackStartedDetails": {
                return Optional.ofNullable(clazz.cast(this.callbackStartedDetails()));
            }
            case "CallbackSucceededDetails": {
                return Optional.ofNullable(clazz.cast(this.callbackSucceededDetails()));
            }
            case "CallbackFailedDetails": {
                return Optional.ofNullable(clazz.cast(this.callbackFailedDetails()));
            }
            case "CallbackTimedOutDetails": {
                return Optional.ofNullable(clazz.cast(this.callbackTimedOutDetails()));
            }
            case "InvocationCompletedDetails": {
                return Optional.ofNullable(clazz.cast(this.invocationCompletedDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        map.put("EventId", EVENT_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EventTimestamp", EVENT_TIMESTAMP_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("ExecutionStartedDetails", EXECUTION_STARTED_DETAILS_FIELD);
        map.put("ExecutionSucceededDetails", EXECUTION_SUCCEEDED_DETAILS_FIELD);
        map.put("ExecutionFailedDetails", EXECUTION_FAILED_DETAILS_FIELD);
        map.put("ExecutionTimedOutDetails", EXECUTION_TIMED_OUT_DETAILS_FIELD);
        map.put("ExecutionStoppedDetails", EXECUTION_STOPPED_DETAILS_FIELD);
        map.put("ContextStartedDetails", CONTEXT_STARTED_DETAILS_FIELD);
        map.put("ContextSucceededDetails", CONTEXT_SUCCEEDED_DETAILS_FIELD);
        map.put("ContextFailedDetails", CONTEXT_FAILED_DETAILS_FIELD);
        map.put("WaitStartedDetails", WAIT_STARTED_DETAILS_FIELD);
        map.put("WaitSucceededDetails", WAIT_SUCCEEDED_DETAILS_FIELD);
        map.put("WaitCancelledDetails", WAIT_CANCELLED_DETAILS_FIELD);
        map.put("StepStartedDetails", STEP_STARTED_DETAILS_FIELD);
        map.put("StepSucceededDetails", STEP_SUCCEEDED_DETAILS_FIELD);
        map.put("StepFailedDetails", STEP_FAILED_DETAILS_FIELD);
        map.put("ChainedInvokeStartedDetails", CHAINED_INVOKE_STARTED_DETAILS_FIELD);
        map.put("ChainedInvokeSucceededDetails", CHAINED_INVOKE_SUCCEEDED_DETAILS_FIELD);
        map.put("ChainedInvokeFailedDetails", CHAINED_INVOKE_FAILED_DETAILS_FIELD);
        map.put("ChainedInvokeTimedOutDetails", CHAINED_INVOKE_TIMED_OUT_DETAILS_FIELD);
        map.put("ChainedInvokeStoppedDetails", CHAINED_INVOKE_STOPPED_DETAILS_FIELD);
        map.put("CallbackStartedDetails", CALLBACK_STARTED_DETAILS_FIELD);
        map.put("CallbackSucceededDetails", CALLBACK_SUCCEEDED_DETAILS_FIELD);
        map.put("CallbackFailedDetails", CALLBACK_FAILED_DETAILS_FIELD);
        map.put("CallbackTimedOutDetails", CALLBACK_TIMED_OUT_DETAILS_FIELD);
        map.put("InvocationCompletedDetails", INVOCATION_COMPLETED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private String subType;
        private Integer eventId;
        private String id;
        private String name;
        private Instant eventTimestamp;
        private String parentId;
        private ExecutionStartedDetails executionStartedDetails;
        private ExecutionSucceededDetails executionSucceededDetails;
        private ExecutionFailedDetails executionFailedDetails;
        private ExecutionTimedOutDetails executionTimedOutDetails;
        private ExecutionStoppedDetails executionStoppedDetails;
        private ContextStartedDetails contextStartedDetails;
        private ContextSucceededDetails contextSucceededDetails;
        private ContextFailedDetails contextFailedDetails;
        private WaitStartedDetails waitStartedDetails;
        private WaitSucceededDetails waitSucceededDetails;
        private WaitCancelledDetails waitCancelledDetails;
        private StepStartedDetails stepStartedDetails;
        private StepSucceededDetails stepSucceededDetails;
        private StepFailedDetails stepFailedDetails;
        private ChainedInvokeStartedDetails chainedInvokeStartedDetails;
        private ChainedInvokeSucceededDetails chainedInvokeSucceededDetails;
        private ChainedInvokeFailedDetails chainedInvokeFailedDetails;
        private ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails;
        private ChainedInvokeStoppedDetails chainedInvokeStoppedDetails;
        private CallbackStartedDetails callbackStartedDetails;
        private CallbackSucceededDetails callbackSucceededDetails;
        private CallbackFailedDetails callbackFailedDetails;
        private CallbackTimedOutDetails callbackTimedOutDetails;
        private InvocationCompletedDetails invocationCompletedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventType(model.eventType);
            this.subType(model.subType);
            this.eventId(model.eventId);
            this.id(model.id);
            this.name(model.name);
            this.eventTimestamp(model.eventTimestamp);
            this.parentId(model.parentId);
            this.executionStartedDetails(model.executionStartedDetails);
            this.executionSucceededDetails(model.executionSucceededDetails);
            this.executionFailedDetails(model.executionFailedDetails);
            this.executionTimedOutDetails(model.executionTimedOutDetails);
            this.executionStoppedDetails(model.executionStoppedDetails);
            this.contextStartedDetails(model.contextStartedDetails);
            this.contextSucceededDetails(model.contextSucceededDetails);
            this.contextFailedDetails(model.contextFailedDetails);
            this.waitStartedDetails(model.waitStartedDetails);
            this.waitSucceededDetails(model.waitSucceededDetails);
            this.waitCancelledDetails(model.waitCancelledDetails);
            this.stepStartedDetails(model.stepStartedDetails);
            this.stepSucceededDetails(model.stepSucceededDetails);
            this.stepFailedDetails(model.stepFailedDetails);
            this.chainedInvokeStartedDetails(model.chainedInvokeStartedDetails);
            this.chainedInvokeSucceededDetails(model.chainedInvokeSucceededDetails);
            this.chainedInvokeFailedDetails(model.chainedInvokeFailedDetails);
            this.chainedInvokeTimedOutDetails(model.chainedInvokeTimedOutDetails);
            this.chainedInvokeStoppedDetails(model.chainedInvokeStoppedDetails);
            this.callbackStartedDetails(model.callbackStartedDetails);
            this.callbackSucceededDetails(model.callbackSucceededDetails);
            this.callbackFailedDetails(model.callbackFailedDetails);
            this.callbackTimedOutDetails(model.callbackTimedOutDetails);
            this.invocationCompletedDetails(model.invocationCompletedDetails);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final Integer getEventId() {
            return this.eventId;
        }

        public final void setEventId(Integer eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(Integer eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final ExecutionStartedDetails.Builder getExecutionStartedDetails() {
            return this.executionStartedDetails != null ? this.executionStartedDetails.toBuilder() : null;
        }

        public final void setExecutionStartedDetails(ExecutionStartedDetails.BuilderImpl executionStartedDetails) {
            this.executionStartedDetails = executionStartedDetails != null ? executionStartedDetails.build() : null;
        }

        @Override
        public final Builder executionStartedDetails(ExecutionStartedDetails executionStartedDetails) {
            this.executionStartedDetails = executionStartedDetails;
            return this;
        }

        public final ExecutionSucceededDetails.Builder getExecutionSucceededDetails() {
            return this.executionSucceededDetails != null ? this.executionSucceededDetails.toBuilder() : null;
        }

        public final void setExecutionSucceededDetails(ExecutionSucceededDetails.BuilderImpl executionSucceededDetails) {
            this.executionSucceededDetails = executionSucceededDetails != null ? executionSucceededDetails.build() : null;
        }

        @Override
        public final Builder executionSucceededDetails(ExecutionSucceededDetails executionSucceededDetails) {
            this.executionSucceededDetails = executionSucceededDetails;
            return this;
        }

        public final ExecutionFailedDetails.Builder getExecutionFailedDetails() {
            return this.executionFailedDetails != null ? this.executionFailedDetails.toBuilder() : null;
        }

        public final void setExecutionFailedDetails(ExecutionFailedDetails.BuilderImpl executionFailedDetails) {
            this.executionFailedDetails = executionFailedDetails != null ? executionFailedDetails.build() : null;
        }

        @Override
        public final Builder executionFailedDetails(ExecutionFailedDetails executionFailedDetails) {
            this.executionFailedDetails = executionFailedDetails;
            return this;
        }

        public final ExecutionTimedOutDetails.Builder getExecutionTimedOutDetails() {
            return this.executionTimedOutDetails != null ? this.executionTimedOutDetails.toBuilder() : null;
        }

        public final void setExecutionTimedOutDetails(ExecutionTimedOutDetails.BuilderImpl executionTimedOutDetails) {
            this.executionTimedOutDetails = executionTimedOutDetails != null ? executionTimedOutDetails.build() : null;
        }

        @Override
        public final Builder executionTimedOutDetails(ExecutionTimedOutDetails executionTimedOutDetails) {
            this.executionTimedOutDetails = executionTimedOutDetails;
            return this;
        }

        public final ExecutionStoppedDetails.Builder getExecutionStoppedDetails() {
            return this.executionStoppedDetails != null ? this.executionStoppedDetails.toBuilder() : null;
        }

        public final void setExecutionStoppedDetails(ExecutionStoppedDetails.BuilderImpl executionStoppedDetails) {
            this.executionStoppedDetails = executionStoppedDetails != null ? executionStoppedDetails.build() : null;
        }

        @Override
        public final Builder executionStoppedDetails(ExecutionStoppedDetails executionStoppedDetails) {
            this.executionStoppedDetails = executionStoppedDetails;
            return this;
        }

        public final ContextStartedDetails.Builder getContextStartedDetails() {
            return this.contextStartedDetails != null ? this.contextStartedDetails.toBuilder() : null;
        }

        public final void setContextStartedDetails(ContextStartedDetails.BuilderImpl contextStartedDetails) {
            this.contextStartedDetails = contextStartedDetails != null ? contextStartedDetails.build() : null;
        }

        @Override
        public final Builder contextStartedDetails(ContextStartedDetails contextStartedDetails) {
            this.contextStartedDetails = contextStartedDetails;
            return this;
        }

        public final ContextSucceededDetails.Builder getContextSucceededDetails() {
            return this.contextSucceededDetails != null ? this.contextSucceededDetails.toBuilder() : null;
        }

        public final void setContextSucceededDetails(ContextSucceededDetails.BuilderImpl contextSucceededDetails) {
            this.contextSucceededDetails = contextSucceededDetails != null ? contextSucceededDetails.build() : null;
        }

        @Override
        public final Builder contextSucceededDetails(ContextSucceededDetails contextSucceededDetails) {
            this.contextSucceededDetails = contextSucceededDetails;
            return this;
        }

        public final ContextFailedDetails.Builder getContextFailedDetails() {
            return this.contextFailedDetails != null ? this.contextFailedDetails.toBuilder() : null;
        }

        public final void setContextFailedDetails(ContextFailedDetails.BuilderImpl contextFailedDetails) {
            this.contextFailedDetails = contextFailedDetails != null ? contextFailedDetails.build() : null;
        }

        @Override
        public final Builder contextFailedDetails(ContextFailedDetails contextFailedDetails) {
            this.contextFailedDetails = contextFailedDetails;
            return this;
        }

        public final WaitStartedDetails.Builder getWaitStartedDetails() {
            return this.waitStartedDetails != null ? this.waitStartedDetails.toBuilder() : null;
        }

        public final void setWaitStartedDetails(WaitStartedDetails.BuilderImpl waitStartedDetails) {
            this.waitStartedDetails = waitStartedDetails != null ? waitStartedDetails.build() : null;
        }

        @Override
        public final Builder waitStartedDetails(WaitStartedDetails waitStartedDetails) {
            this.waitStartedDetails = waitStartedDetails;
            return this;
        }

        public final WaitSucceededDetails.Builder getWaitSucceededDetails() {
            return this.waitSucceededDetails != null ? this.waitSucceededDetails.toBuilder() : null;
        }

        public final void setWaitSucceededDetails(WaitSucceededDetails.BuilderImpl waitSucceededDetails) {
            this.waitSucceededDetails = waitSucceededDetails != null ? waitSucceededDetails.build() : null;
        }

        @Override
        public final Builder waitSucceededDetails(WaitSucceededDetails waitSucceededDetails) {
            this.waitSucceededDetails = waitSucceededDetails;
            return this;
        }

        public final WaitCancelledDetails.Builder getWaitCancelledDetails() {
            return this.waitCancelledDetails != null ? this.waitCancelledDetails.toBuilder() : null;
        }

        public final void setWaitCancelledDetails(WaitCancelledDetails.BuilderImpl waitCancelledDetails) {
            this.waitCancelledDetails = waitCancelledDetails != null ? waitCancelledDetails.build() : null;
        }

        @Override
        public final Builder waitCancelledDetails(WaitCancelledDetails waitCancelledDetails) {
            this.waitCancelledDetails = waitCancelledDetails;
            return this;
        }

        public final StepStartedDetails.Builder getStepStartedDetails() {
            return this.stepStartedDetails != null ? this.stepStartedDetails.toBuilder() : null;
        }

        public final void setStepStartedDetails(StepStartedDetails.BuilderImpl stepStartedDetails) {
            this.stepStartedDetails = stepStartedDetails != null ? stepStartedDetails.build() : null;
        }

        @Override
        public final Builder stepStartedDetails(StepStartedDetails stepStartedDetails) {
            this.stepStartedDetails = stepStartedDetails;
            return this;
        }

        public final StepSucceededDetails.Builder getStepSucceededDetails() {
            return this.stepSucceededDetails != null ? this.stepSucceededDetails.toBuilder() : null;
        }

        public final void setStepSucceededDetails(StepSucceededDetails.BuilderImpl stepSucceededDetails) {
            this.stepSucceededDetails = stepSucceededDetails != null ? stepSucceededDetails.build() : null;
        }

        @Override
        public final Builder stepSucceededDetails(StepSucceededDetails stepSucceededDetails) {
            this.stepSucceededDetails = stepSucceededDetails;
            return this;
        }

        public final StepFailedDetails.Builder getStepFailedDetails() {
            return this.stepFailedDetails != null ? this.stepFailedDetails.toBuilder() : null;
        }

        public final void setStepFailedDetails(StepFailedDetails.BuilderImpl stepFailedDetails) {
            this.stepFailedDetails = stepFailedDetails != null ? stepFailedDetails.build() : null;
        }

        @Override
        public final Builder stepFailedDetails(StepFailedDetails stepFailedDetails) {
            this.stepFailedDetails = stepFailedDetails;
            return this;
        }

        public final ChainedInvokeStartedDetails.Builder getChainedInvokeStartedDetails() {
            return this.chainedInvokeStartedDetails != null ? this.chainedInvokeStartedDetails.toBuilder() : null;
        }

        public final void setChainedInvokeStartedDetails(ChainedInvokeStartedDetails.BuilderImpl chainedInvokeStartedDetails) {
            this.chainedInvokeStartedDetails = chainedInvokeStartedDetails != null ? chainedInvokeStartedDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeStartedDetails(ChainedInvokeStartedDetails chainedInvokeStartedDetails) {
            this.chainedInvokeStartedDetails = chainedInvokeStartedDetails;
            return this;
        }

        public final ChainedInvokeSucceededDetails.Builder getChainedInvokeSucceededDetails() {
            return this.chainedInvokeSucceededDetails != null ? this.chainedInvokeSucceededDetails.toBuilder() : null;
        }

        public final void setChainedInvokeSucceededDetails(ChainedInvokeSucceededDetails.BuilderImpl chainedInvokeSucceededDetails) {
            this.chainedInvokeSucceededDetails = chainedInvokeSucceededDetails != null ? chainedInvokeSucceededDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails chainedInvokeSucceededDetails) {
            this.chainedInvokeSucceededDetails = chainedInvokeSucceededDetails;
            return this;
        }

        public final ChainedInvokeFailedDetails.Builder getChainedInvokeFailedDetails() {
            return this.chainedInvokeFailedDetails != null ? this.chainedInvokeFailedDetails.toBuilder() : null;
        }

        public final void setChainedInvokeFailedDetails(ChainedInvokeFailedDetails.BuilderImpl chainedInvokeFailedDetails) {
            this.chainedInvokeFailedDetails = chainedInvokeFailedDetails != null ? chainedInvokeFailedDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeFailedDetails(ChainedInvokeFailedDetails chainedInvokeFailedDetails) {
            this.chainedInvokeFailedDetails = chainedInvokeFailedDetails;
            return this;
        }

        public final ChainedInvokeTimedOutDetails.Builder getChainedInvokeTimedOutDetails() {
            return this.chainedInvokeTimedOutDetails != null ? this.chainedInvokeTimedOutDetails.toBuilder() : null;
        }

        public final void setChainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails.BuilderImpl chainedInvokeTimedOutDetails) {
            this.chainedInvokeTimedOutDetails = chainedInvokeTimedOutDetails != null ? chainedInvokeTimedOutDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails chainedInvokeTimedOutDetails) {
            this.chainedInvokeTimedOutDetails = chainedInvokeTimedOutDetails;
            return this;
        }

        public final ChainedInvokeStoppedDetails.Builder getChainedInvokeStoppedDetails() {
            return this.chainedInvokeStoppedDetails != null ? this.chainedInvokeStoppedDetails.toBuilder() : null;
        }

        public final void setChainedInvokeStoppedDetails(ChainedInvokeStoppedDetails.BuilderImpl chainedInvokeStoppedDetails) {
            this.chainedInvokeStoppedDetails = chainedInvokeStoppedDetails != null ? chainedInvokeStoppedDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails chainedInvokeStoppedDetails) {
            this.chainedInvokeStoppedDetails = chainedInvokeStoppedDetails;
            return this;
        }

        public final CallbackStartedDetails.Builder getCallbackStartedDetails() {
            return this.callbackStartedDetails != null ? this.callbackStartedDetails.toBuilder() : null;
        }

        public final void setCallbackStartedDetails(CallbackStartedDetails.BuilderImpl callbackStartedDetails) {
            this.callbackStartedDetails = callbackStartedDetails != null ? callbackStartedDetails.build() : null;
        }

        @Override
        public final Builder callbackStartedDetails(CallbackStartedDetails callbackStartedDetails) {
            this.callbackStartedDetails = callbackStartedDetails;
            return this;
        }

        public final CallbackSucceededDetails.Builder getCallbackSucceededDetails() {
            return this.callbackSucceededDetails != null ? this.callbackSucceededDetails.toBuilder() : null;
        }

        public final void setCallbackSucceededDetails(CallbackSucceededDetails.BuilderImpl callbackSucceededDetails) {
            this.callbackSucceededDetails = callbackSucceededDetails != null ? callbackSucceededDetails.build() : null;
        }

        @Override
        public final Builder callbackSucceededDetails(CallbackSucceededDetails callbackSucceededDetails) {
            this.callbackSucceededDetails = callbackSucceededDetails;
            return this;
        }

        public final CallbackFailedDetails.Builder getCallbackFailedDetails() {
            return this.callbackFailedDetails != null ? this.callbackFailedDetails.toBuilder() : null;
        }

        public final void setCallbackFailedDetails(CallbackFailedDetails.BuilderImpl callbackFailedDetails) {
            this.callbackFailedDetails = callbackFailedDetails != null ? callbackFailedDetails.build() : null;
        }

        @Override
        public final Builder callbackFailedDetails(CallbackFailedDetails callbackFailedDetails) {
            this.callbackFailedDetails = callbackFailedDetails;
            return this;
        }

        public final CallbackTimedOutDetails.Builder getCallbackTimedOutDetails() {
            return this.callbackTimedOutDetails != null ? this.callbackTimedOutDetails.toBuilder() : null;
        }

        public final void setCallbackTimedOutDetails(CallbackTimedOutDetails.BuilderImpl callbackTimedOutDetails) {
            this.callbackTimedOutDetails = callbackTimedOutDetails != null ? callbackTimedOutDetails.build() : null;
        }

        @Override
        public final Builder callbackTimedOutDetails(CallbackTimedOutDetails callbackTimedOutDetails) {
            this.callbackTimedOutDetails = callbackTimedOutDetails;
            return this;
        }

        public final InvocationCompletedDetails.Builder getInvocationCompletedDetails() {
            return this.invocationCompletedDetails != null ? this.invocationCompletedDetails.toBuilder() : null;
        }

        public final void setInvocationCompletedDetails(InvocationCompletedDetails.BuilderImpl invocationCompletedDetails) {
            this.invocationCompletedDetails = invocationCompletedDetails != null ? invocationCompletedDetails.build() : null;
        }

        @Override
        public final Builder invocationCompletedDetails(InvocationCompletedDetails invocationCompletedDetails) {
            this.invocationCompletedDetails = invocationCompletedDetails;
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder subType(String var1);

        public Builder eventId(Integer var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder eventTimestamp(Instant var1);

        public Builder parentId(String var1);

        public Builder executionStartedDetails(ExecutionStartedDetails var1);

        default public Builder executionStartedDetails(Consumer<ExecutionStartedDetails.Builder> executionStartedDetails) {
            return this.executionStartedDetails((ExecutionStartedDetails)((ExecutionStartedDetails.Builder)ExecutionStartedDetails.builder().applyMutation(executionStartedDetails)).build());
        }

        public Builder executionSucceededDetails(ExecutionSucceededDetails var1);

        default public Builder executionSucceededDetails(Consumer<ExecutionSucceededDetails.Builder> executionSucceededDetails) {
            return this.executionSucceededDetails((ExecutionSucceededDetails)((ExecutionSucceededDetails.Builder)ExecutionSucceededDetails.builder().applyMutation(executionSucceededDetails)).build());
        }

        public Builder executionFailedDetails(ExecutionFailedDetails var1);

        default public Builder executionFailedDetails(Consumer<ExecutionFailedDetails.Builder> executionFailedDetails) {
            return this.executionFailedDetails((ExecutionFailedDetails)((ExecutionFailedDetails.Builder)ExecutionFailedDetails.builder().applyMutation(executionFailedDetails)).build());
        }

        public Builder executionTimedOutDetails(ExecutionTimedOutDetails var1);

        default public Builder executionTimedOutDetails(Consumer<ExecutionTimedOutDetails.Builder> executionTimedOutDetails) {
            return this.executionTimedOutDetails((ExecutionTimedOutDetails)((ExecutionTimedOutDetails.Builder)ExecutionTimedOutDetails.builder().applyMutation(executionTimedOutDetails)).build());
        }

        public Builder executionStoppedDetails(ExecutionStoppedDetails var1);

        default public Builder executionStoppedDetails(Consumer<ExecutionStoppedDetails.Builder> executionStoppedDetails) {
            return this.executionStoppedDetails((ExecutionStoppedDetails)((ExecutionStoppedDetails.Builder)ExecutionStoppedDetails.builder().applyMutation(executionStoppedDetails)).build());
        }

        public Builder contextStartedDetails(ContextStartedDetails var1);

        default public Builder contextStartedDetails(Consumer<ContextStartedDetails.Builder> contextStartedDetails) {
            return this.contextStartedDetails((ContextStartedDetails)((ContextStartedDetails.Builder)ContextStartedDetails.builder().applyMutation(contextStartedDetails)).build());
        }

        public Builder contextSucceededDetails(ContextSucceededDetails var1);

        default public Builder contextSucceededDetails(Consumer<ContextSucceededDetails.Builder> contextSucceededDetails) {
            return this.contextSucceededDetails((ContextSucceededDetails)((ContextSucceededDetails.Builder)ContextSucceededDetails.builder().applyMutation(contextSucceededDetails)).build());
        }

        public Builder contextFailedDetails(ContextFailedDetails var1);

        default public Builder contextFailedDetails(Consumer<ContextFailedDetails.Builder> contextFailedDetails) {
            return this.contextFailedDetails((ContextFailedDetails)((ContextFailedDetails.Builder)ContextFailedDetails.builder().applyMutation(contextFailedDetails)).build());
        }

        public Builder waitStartedDetails(WaitStartedDetails var1);

        default public Builder waitStartedDetails(Consumer<WaitStartedDetails.Builder> waitStartedDetails) {
            return this.waitStartedDetails((WaitStartedDetails)((WaitStartedDetails.Builder)WaitStartedDetails.builder().applyMutation(waitStartedDetails)).build());
        }

        public Builder waitSucceededDetails(WaitSucceededDetails var1);

        default public Builder waitSucceededDetails(Consumer<WaitSucceededDetails.Builder> waitSucceededDetails) {
            return this.waitSucceededDetails((WaitSucceededDetails)((WaitSucceededDetails.Builder)WaitSucceededDetails.builder().applyMutation(waitSucceededDetails)).build());
        }

        public Builder waitCancelledDetails(WaitCancelledDetails var1);

        default public Builder waitCancelledDetails(Consumer<WaitCancelledDetails.Builder> waitCancelledDetails) {
            return this.waitCancelledDetails((WaitCancelledDetails)((WaitCancelledDetails.Builder)WaitCancelledDetails.builder().applyMutation(waitCancelledDetails)).build());
        }

        public Builder stepStartedDetails(StepStartedDetails var1);

        default public Builder stepStartedDetails(Consumer<StepStartedDetails.Builder> stepStartedDetails) {
            return this.stepStartedDetails((StepStartedDetails)((StepStartedDetails.Builder)StepStartedDetails.builder().applyMutation(stepStartedDetails)).build());
        }

        public Builder stepSucceededDetails(StepSucceededDetails var1);

        default public Builder stepSucceededDetails(Consumer<StepSucceededDetails.Builder> stepSucceededDetails) {
            return this.stepSucceededDetails((StepSucceededDetails)((StepSucceededDetails.Builder)StepSucceededDetails.builder().applyMutation(stepSucceededDetails)).build());
        }

        public Builder stepFailedDetails(StepFailedDetails var1);

        default public Builder stepFailedDetails(Consumer<StepFailedDetails.Builder> stepFailedDetails) {
            return this.stepFailedDetails((StepFailedDetails)((StepFailedDetails.Builder)StepFailedDetails.builder().applyMutation(stepFailedDetails)).build());
        }

        public Builder chainedInvokeStartedDetails(ChainedInvokeStartedDetails var1);

        default public Builder chainedInvokeStartedDetails(Consumer<ChainedInvokeStartedDetails.Builder> chainedInvokeStartedDetails) {
            return this.chainedInvokeStartedDetails((ChainedInvokeStartedDetails)((ChainedInvokeStartedDetails.Builder)ChainedInvokeStartedDetails.builder().applyMutation(chainedInvokeStartedDetails)).build());
        }

        public Builder chainedInvokeSucceededDetails(ChainedInvokeSucceededDetails var1);

        default public Builder chainedInvokeSucceededDetails(Consumer<ChainedInvokeSucceededDetails.Builder> chainedInvokeSucceededDetails) {
            return this.chainedInvokeSucceededDetails((ChainedInvokeSucceededDetails)((ChainedInvokeSucceededDetails.Builder)ChainedInvokeSucceededDetails.builder().applyMutation(chainedInvokeSucceededDetails)).build());
        }

        public Builder chainedInvokeFailedDetails(ChainedInvokeFailedDetails var1);

        default public Builder chainedInvokeFailedDetails(Consumer<ChainedInvokeFailedDetails.Builder> chainedInvokeFailedDetails) {
            return this.chainedInvokeFailedDetails((ChainedInvokeFailedDetails)((ChainedInvokeFailedDetails.Builder)ChainedInvokeFailedDetails.builder().applyMutation(chainedInvokeFailedDetails)).build());
        }

        public Builder chainedInvokeTimedOutDetails(ChainedInvokeTimedOutDetails var1);

        default public Builder chainedInvokeTimedOutDetails(Consumer<ChainedInvokeTimedOutDetails.Builder> chainedInvokeTimedOutDetails) {
            return this.chainedInvokeTimedOutDetails((ChainedInvokeTimedOutDetails)((ChainedInvokeTimedOutDetails.Builder)ChainedInvokeTimedOutDetails.builder().applyMutation(chainedInvokeTimedOutDetails)).build());
        }

        public Builder chainedInvokeStoppedDetails(ChainedInvokeStoppedDetails var1);

        default public Builder chainedInvokeStoppedDetails(Consumer<ChainedInvokeStoppedDetails.Builder> chainedInvokeStoppedDetails) {
            return this.chainedInvokeStoppedDetails((ChainedInvokeStoppedDetails)((ChainedInvokeStoppedDetails.Builder)ChainedInvokeStoppedDetails.builder().applyMutation(chainedInvokeStoppedDetails)).build());
        }

        public Builder callbackStartedDetails(CallbackStartedDetails var1);

        default public Builder callbackStartedDetails(Consumer<CallbackStartedDetails.Builder> callbackStartedDetails) {
            return this.callbackStartedDetails((CallbackStartedDetails)((CallbackStartedDetails.Builder)CallbackStartedDetails.builder().applyMutation(callbackStartedDetails)).build());
        }

        public Builder callbackSucceededDetails(CallbackSucceededDetails var1);

        default public Builder callbackSucceededDetails(Consumer<CallbackSucceededDetails.Builder> callbackSucceededDetails) {
            return this.callbackSucceededDetails((CallbackSucceededDetails)((CallbackSucceededDetails.Builder)CallbackSucceededDetails.builder().applyMutation(callbackSucceededDetails)).build());
        }

        public Builder callbackFailedDetails(CallbackFailedDetails var1);

        default public Builder callbackFailedDetails(Consumer<CallbackFailedDetails.Builder> callbackFailedDetails) {
            return this.callbackFailedDetails((CallbackFailedDetails)((CallbackFailedDetails.Builder)CallbackFailedDetails.builder().applyMutation(callbackFailedDetails)).build());
        }

        public Builder callbackTimedOutDetails(CallbackTimedOutDetails var1);

        default public Builder callbackTimedOutDetails(Consumer<CallbackTimedOutDetails.Builder> callbackTimedOutDetails) {
            return this.callbackTimedOutDetails((CallbackTimedOutDetails)((CallbackTimedOutDetails.Builder)CallbackTimedOutDetails.builder().applyMutation(callbackTimedOutDetails)).build());
        }

        public Builder invocationCompletedDetails(InvocationCompletedDetails var1);

        default public Builder invocationCompletedDetails(Consumer<InvocationCompletedDetails.Builder> invocationCompletedDetails) {
            return this.invocationCompletedDetails((InvocationCompletedDetails)((InvocationCompletedDetails.Builder)InvocationCompletedDetails.builder().applyMutation(invocationCompletedDetails)).build());
        }
    }
}

