/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StateReasonCode {
    IDLE("Idle"),
    CREATING("Creating"),
    RESTORING("Restoring"),
    ENI_LIMIT_EXCEEDED("EniLimitExceeded"),
    INSUFFICIENT_ROLE_PERMISSIONS("InsufficientRolePermissions"),
    INVALID_CONFIGURATION("InvalidConfiguration"),
    INTERNAL_ERROR("InternalError"),
    SUBNET_OUT_OF_IP_ADDRESSES("SubnetOutOfIPAddresses"),
    INVALID_SUBNET("InvalidSubnet"),
    INVALID_SECURITY_GROUP("InvalidSecurityGroup"),
    IMAGE_DELETED("ImageDeleted"),
    IMAGE_ACCESS_DENIED("ImageAccessDenied"),
    INVALID_IMAGE("InvalidImage"),
    KMS_KEY_ACCESS_DENIED("KMSKeyAccessDenied"),
    KMS_KEY_NOT_FOUND("KMSKeyNotFound"),
    INVALID_STATE_KMS_KEY("InvalidStateKMSKey"),
    DISABLED_KMS_KEY("DisabledKMSKey"),
    EFSIO_ERROR("EFSIOError"),
    EFS_MOUNT_CONNECTIVITY_ERROR("EFSMountConnectivityError"),
    EFS_MOUNT_FAILURE("EFSMountFailure"),
    EFS_MOUNT_TIMEOUT("EFSMountTimeout"),
    INVALID_RUNTIME("InvalidRuntime"),
    INVALID_ZIP_FILE_EXCEPTION("InvalidZipFileException"),
    FUNCTION_ERROR("FunctionError"),
    VCPU_LIMIT_EXCEEDED("VcpuLimitExceeded"),
    CAPACITY_PROVIDER_SCALING_LIMIT_EXCEEDED("CapacityProviderScalingLimitExceeded"),
    INSUFFICIENT_CAPACITY("InsufficientCapacity"),
    EC2_REQUEST_LIMIT_EXCEEDED("EC2RequestLimitExceeded"),
    FUNCTION_ERROR_INIT_TIMEOUT("FunctionError.InitTimeout"),
    FUNCTION_ERROR_RUNTIME_INIT_ERROR("FunctionError.RuntimeInitError"),
    FUNCTION_ERROR_EXTENSION_INIT_ERROR("FunctionError.ExtensionInitError"),
    FUNCTION_ERROR_INVALID_ENTRY_POINT("FunctionError.InvalidEntryPoint"),
    FUNCTION_ERROR_INVALID_WORKING_DIRECTORY("FunctionError.InvalidWorkingDirectory"),
    FUNCTION_ERROR_PERMISSION_DENIED("FunctionError.PermissionDenied"),
    FUNCTION_ERROR_TOO_MANY_EXTENSIONS("FunctionError.TooManyExtensions"),
    FUNCTION_ERROR_INIT_RESOURCE_EXHAUSTED("FunctionError.InitResourceExhausted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StateReasonCode> VALUE_MAP;
    private final String value;

    private StateReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateReasonCode> knownValues() {
        EnumSet<StateReasonCode> knownValues = EnumSet.allOf(StateReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StateReasonCode.class, StateReasonCode::toString);
    }
}

