/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.Architecture;
import software.amazon.awssdk.services.lambda.model.ArchitecturesListCopier;
import software.amazon.awssdk.services.lambda.model.CapacityProviderConfig;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.EphemeralStorage;
import software.amazon.awssdk.services.lambda.model.FileSystemConfig;
import software.amazon.awssdk.services.lambda.model.FileSystemConfigListCopier;
import software.amazon.awssdk.services.lambda.model.FunctionCode;
import software.amazon.awssdk.services.lambda.model.FunctionVersionLatestPublished;
import software.amazon.awssdk.services.lambda.model.ImageConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LayerListCopier;
import software.amazon.awssdk.services.lambda.model.LoggingConfig;
import software.amazon.awssdk.services.lambda.model.PackageType;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.SnapStart;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.services.lambda.model.TenancyConfig;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFunctionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateFunctionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(CreateFunctionRequest.getter(CreateFunctionRequest::functionName)).setter(CreateFunctionRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Runtime").getter(CreateFunctionRequest.getter(CreateFunctionRequest::runtimeAsString)).setter(CreateFunctionRequest.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateFunctionRequest.getter(CreateFunctionRequest::role)).setter(CreateFunctionRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(CreateFunctionRequest.getter(CreateFunctionRequest::handler)).setter(CreateFunctionRequest.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<FunctionCode> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(CreateFunctionRequest.getter(CreateFunctionRequest::code)).setter(CreateFunctionRequest.setter(Builder::code)).constructor(FunctionCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFunctionRequest.getter(CreateFunctionRequest::description)).setter(CreateFunctionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(CreateFunctionRequest.getter(CreateFunctionRequest::timeout)).setter(CreateFunctionRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySize").getter(CreateFunctionRequest.getter(CreateFunctionRequest::memorySize)).setter(CreateFunctionRequest.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Publish").getter(CreateFunctionRequest.getter(CreateFunctionRequest::publish)).setter(CreateFunctionRequest.setter(Builder::publish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publish").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::vpcConfig)).setter(CreateFunctionRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(CreateFunctionRequest.getter(CreateFunctionRequest::packageTypeAsString)).setter(CreateFunctionRequest.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::deadLetterConfig)).setter(CreateFunctionRequest.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(CreateFunctionRequest.getter(CreateFunctionRequest::environment)).setter(CreateFunctionRequest.setter(Builder::environment)).constructor(Environment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyArn").getter(CreateFunctionRequest.getter(CreateFunctionRequest::kmsKeyArn)).setter(CreateFunctionRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final SdkField<TracingConfig> TRACING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TracingConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::tracingConfig)).setter(CreateFunctionRequest.setter(Builder::tracingConfig)).constructor(TracingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateFunctionRequest.getter(CreateFunctionRequest::tags)).setter(CreateFunctionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layers").getter(CreateFunctionRequest.getter(CreateFunctionRequest::layers)).setter(CreateFunctionRequest.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemConfigs").getter(CreateFunctionRequest.getter(CreateFunctionRequest::fileSystemConfigs)).setter(CreateFunctionRequest.setter(Builder::fileSystemConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::imageConfig)).setter(CreateFunctionRequest.setter(Builder::imageConfig)).constructor(ImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()}).build();
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSigningConfigArn").getter(CreateFunctionRequest.getter(CreateFunctionRequest::codeSigningConfigArn)).setter(CreateFunctionRequest.setter(Builder::codeSigningConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Architectures").getter(CreateFunctionRequest.getter(CreateFunctionRequest::architecturesAsStrings)).setter(CreateFunctionRequest.setter(Builder::architecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EphemeralStorage").getter(CreateFunctionRequest.getter(CreateFunctionRequest::ephemeralStorage)).setter(CreateFunctionRequest.setter(Builder::ephemeralStorage)).constructor(EphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").build()}).build();
    private static final SdkField<SnapStart> SNAP_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapStart").getter(CreateFunctionRequest.getter(CreateFunctionRequest::snapStart)).setter(CreateFunctionRequest.setter(Builder::snapStart)).constructor(SnapStart::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapStart").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::loggingConfig)).setter(CreateFunctionRequest.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()}).build();
    private static final SdkField<CapacityProviderConfig> CAPACITY_PROVIDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityProviderConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::capacityProviderConfig)).setter(CreateFunctionRequest.setter(Builder::capacityProviderConfig)).constructor(CapacityProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderConfig").build()}).build();
    private static final SdkField<String> PUBLISH_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishTo").getter(CreateFunctionRequest.getter(CreateFunctionRequest::publishToAsString)).setter(CreateFunctionRequest.setter(Builder::publishTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishTo").build()}).build();
    private static final SdkField<TenancyConfig> TENANCY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TenancyConfig").getter(CreateFunctionRequest.getter(CreateFunctionRequest::tenancyConfig)).setter(CreateFunctionRequest.setter(Builder::tenancyConfig)).constructor(TenancyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenancyConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD, PUBLISH_FIELD, VPC_CONFIG_FIELD, PACKAGE_TYPE_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, TAGS_FIELD, LAYERS_FIELD, FILE_SYSTEM_CONFIGS_FIELD, IMAGE_CONFIG_FIELD, CODE_SIGNING_CONFIG_ARN_FIELD, ARCHITECTURES_FIELD, EPHEMERAL_STORAGE_FIELD, SNAP_START_FIELD, LOGGING_CONFIG_FIELD, CAPACITY_PROVIDER_CONFIG_FIELD, PUBLISH_TO_FIELD, TENANCY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFunctionRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String runtime;
    private final String role;
    private final String handler;
    private final FunctionCode code;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final Boolean publish;
    private final VpcConfig vpcConfig;
    private final String packageType;
    private final DeadLetterConfig deadLetterConfig;
    private final Environment environment;
    private final String kmsKeyArn;
    private final TracingConfig tracingConfig;
    private final Map<String, String> tags;
    private final List<String> layers;
    private final List<FileSystemConfig> fileSystemConfigs;
    private final ImageConfig imageConfig;
    private final String codeSigningConfigArn;
    private final List<String> architectures;
    private final EphemeralStorage ephemeralStorage;
    private final SnapStart snapStart;
    private final LoggingConfig loggingConfig;
    private final CapacityProviderConfig capacityProviderConfig;
    private final String publishTo;
    private final TenancyConfig tenancyConfig;

    private CreateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.code = builder.code;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.publish = builder.publish;
        this.vpcConfig = builder.vpcConfig;
        this.packageType = builder.packageType;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.tags = builder.tags;
        this.layers = builder.layers;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.imageConfig = builder.imageConfig;
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.architectures = builder.architectures;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.snapStart = builder.snapStart;
        this.loggingConfig = builder.loggingConfig;
        this.capacityProviderConfig = builder.capacityProviderConfig;
        this.publishTo = builder.publishTo;
        this.tenancyConfig = builder.tenancyConfig;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String role() {
        return this.role;
    }

    public final String handler() {
        return this.handler;
    }

    public final FunctionCode code() {
        return this.code;
    }

    public final String description() {
        return this.description;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer memorySize() {
        return this.memorySize;
    }

    public final Boolean publish() {
        return this.publish;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final Environment environment() {
        return this.environment;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final TracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<String> layers() {
        return this.layers;
    }

    public final boolean hasFileSystemConfigs() {
        return this.fileSystemConfigs != null && !(this.fileSystemConfigs instanceof SdkAutoConstructList);
    }

    public final List<FileSystemConfig> fileSystemConfigs() {
        return this.fileSystemConfigs;
    }

    public final ImageConfig imageConfig() {
        return this.imageConfig;
    }

    public final String codeSigningConfigArn() {
        return this.codeSigningConfigArn;
    }

    public final List<Architecture> architectures() {
        return ArchitecturesListCopier.copyStringToEnum(this.architectures);
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architecturesAsStrings() {
        return this.architectures;
    }

    public final EphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final SnapStart snapStart() {
        return this.snapStart;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public final CapacityProviderConfig capacityProviderConfig() {
        return this.capacityProviderConfig;
    }

    public final FunctionVersionLatestPublished publishTo() {
        return FunctionVersionLatestPublished.fromValue(this.publishTo);
    }

    public final String publishToAsString() {
        return this.publishTo;
    }

    public final TenancyConfig tenancyConfig() {
        return this.tenancyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.publish());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishToAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionRequest)) {
            return false;
        }
        CreateFunctionRequest other = (CreateFunctionRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.publish(), other.publish()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && this.hasFileSystemConfigs() == other.hasFileSystemConfigs() && Objects.equals(this.fileSystemConfigs(), other.fileSystemConfigs()) && Objects.equals(this.imageConfig(), other.imageConfig()) && Objects.equals(this.codeSigningConfigArn(), other.codeSigningConfigArn()) && this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architecturesAsStrings(), other.architecturesAsStrings()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.snapStart(), other.snapStart()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.capacityProviderConfig(), other.capacityProviderConfig()) && Objects.equals(this.publishToAsString(), other.publishToAsString()) && Objects.equals(this.tenancyConfig(), other.tenancyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFunctionRequest").add("FunctionName", (Object)this.functionName()).add("Runtime", (Object)this.runtimeAsString()).add("Role", (Object)this.role()).add("Handler", (Object)this.handler()).add("Code", (Object)this.code()).add("Description", (Object)this.description()).add("Timeout", (Object)this.timeout()).add("MemorySize", (Object)this.memorySize()).add("Publish", (Object)this.publish()).add("VpcConfig", (Object)this.vpcConfig()).add("PackageType", (Object)this.packageTypeAsString()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("Environment", (Object)this.environment()).add("KMSKeyArn", (Object)this.kmsKeyArn()).add("TracingConfig", (Object)this.tracingConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("Layers", this.hasLayers() ? this.layers() : null).add("FileSystemConfigs", this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null).add("ImageConfig", (Object)this.imageConfig()).add("CodeSigningConfigArn", (Object)this.codeSigningConfigArn()).add("Architectures", this.hasArchitectures() ? this.architecturesAsStrings() : null).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("SnapStart", (Object)this.snapStart()).add("LoggingConfig", (Object)this.loggingConfig()).add("CapacityProviderConfig", (Object)this.capacityProviderConfig()).add("PublishTo", (Object)this.publishToAsString()).add("TenancyConfig", (Object)this.tenancyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "Publish": {
                return Optional.ofNullable(clazz.cast(this.publish()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.ofNullable(clazz.cast(this.tracingConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "FileSystemConfigs": {
                return Optional.ofNullable(clazz.cast(this.fileSystemConfigs()));
            }
            case "ImageConfig": {
                return Optional.ofNullable(clazz.cast(this.imageConfig()));
            }
            case "CodeSigningConfigArn": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigArn()));
            }
            case "Architectures": {
                return Optional.ofNullable(clazz.cast(this.architecturesAsStrings()));
            }
            case "EphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "SnapStart": {
                return Optional.ofNullable(clazz.cast(this.snapStart()));
            }
            case "LoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "CapacityProviderConfig": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderConfig()));
            }
            case "PublishTo": {
                return Optional.ofNullable(clazz.cast(this.publishToAsString()));
            }
            case "TenancyConfig": {
                return Optional.ofNullable(clazz.cast(this.tenancyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Runtime", RUNTIME_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("Handler", HANDLER_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("MemorySize", MEMORY_SIZE_FIELD);
        map.put("Publish", PUBLISH_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("KMSKeyArn", KMS_KEY_ARN_FIELD);
        map.put("TracingConfig", TRACING_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Layers", LAYERS_FIELD);
        map.put("FileSystemConfigs", FILE_SYSTEM_CONFIGS_FIELD);
        map.put("ImageConfig", IMAGE_CONFIG_FIELD);
        map.put("CodeSigningConfigArn", CODE_SIGNING_CONFIG_ARN_FIELD);
        map.put("Architectures", ARCHITECTURES_FIELD);
        map.put("EphemeralStorage", EPHEMERAL_STORAGE_FIELD);
        map.put("SnapStart", SNAP_START_FIELD);
        map.put("LoggingConfig", LOGGING_CONFIG_FIELD);
        map.put("CapacityProviderConfig", CAPACITY_PROVIDER_CONFIG_FIELD);
        map.put("PublishTo", PUBLISH_TO_FIELD);
        map.put("TenancyConfig", TENANCY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionRequest, T> g) {
        return obj -> g.apply((CreateFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String runtime;
        private String role;
        private String handler;
        private FunctionCode code;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private Boolean publish;
        private VpcConfig vpcConfig;
        private String packageType;
        private DeadLetterConfig deadLetterConfig;
        private Environment environment;
        private String kmsKeyArn;
        private TracingConfig tracingConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> layers = DefaultSdkAutoConstructList.getInstance();
        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();
        private ImageConfig imageConfig;
        private String codeSigningConfigArn;
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private EphemeralStorage ephemeralStorage;
        private SnapStart snapStart;
        private LoggingConfig loggingConfig;
        private CapacityProviderConfig capacityProviderConfig;
        private String publishTo;
        private TenancyConfig tenancyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.runtime(model.runtime);
            this.role(model.role);
            this.handler(model.handler);
            this.code(model.code);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.publish(model.publish);
            this.vpcConfig(model.vpcConfig);
            this.packageType(model.packageType);
            this.deadLetterConfig(model.deadLetterConfig);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
            this.tags(model.tags);
            this.layers(model.layers);
            this.fileSystemConfigs(model.fileSystemConfigs);
            this.imageConfig(model.imageConfig);
            this.codeSigningConfigArn(model.codeSigningConfigArn);
            this.architecturesWithStrings(model.architectures);
            this.ephemeralStorage(model.ephemeralStorage);
            this.snapStart(model.snapStart);
            this.loggingConfig(model.loggingConfig);
            this.capacityProviderConfig(model.capacityProviderConfig);
            this.publishTo(model.publishTo);
            this.tenancyConfig(model.tenancyConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getHandler() {
            return this.handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final FunctionCode.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(FunctionCode.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(FunctionCode code) {
            this.code = code;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final Boolean getPublish() {
            return this.publish;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final Environment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Collection<String> getLayers() {
            if (this.layers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.layers;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final List<FileSystemConfig.Builder> getFileSystemConfigs() {
            List<FileSystemConfig.Builder> result = FileSystemConfigListCopier.copyToBuilder(this.fileSystemConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig ... fileSystemConfigs) {
            this.fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... fileSystemConfigs) {
            this.fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> (FileSystemConfig)((FileSystemConfig.Builder)FileSystemConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ImageConfig.Builder getImageConfig() {
            return this.imageConfig != null ? this.imageConfig.toBuilder() : null;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final String getCodeSigningConfigArn() {
            return this.codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
        }

        @Override
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecturesWithStrings(String ... architectures) {
            this.architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitecturesListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Architecture ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final SnapStart.Builder getSnapStart() {
            return this.snapStart != null ? this.snapStart.toBuilder() : null;
        }

        public final void setSnapStart(SnapStart.BuilderImpl snapStart) {
            this.snapStart = snapStart != null ? snapStart.build() : null;
        }

        @Override
        public final Builder snapStart(SnapStart snapStart) {
            this.snapStart = snapStart;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final CapacityProviderConfig.Builder getCapacityProviderConfig() {
            return this.capacityProviderConfig != null ? this.capacityProviderConfig.toBuilder() : null;
        }

        public final void setCapacityProviderConfig(CapacityProviderConfig.BuilderImpl capacityProviderConfig) {
            this.capacityProviderConfig = capacityProviderConfig != null ? capacityProviderConfig.build() : null;
        }

        @Override
        public final Builder capacityProviderConfig(CapacityProviderConfig capacityProviderConfig) {
            this.capacityProviderConfig = capacityProviderConfig;
            return this;
        }

        public final String getPublishTo() {
            return this.publishTo;
        }

        public final void setPublishTo(String publishTo) {
            this.publishTo = publishTo;
        }

        @Override
        public final Builder publishTo(String publishTo) {
            this.publishTo = publishTo;
            return this;
        }

        @Override
        public final Builder publishTo(FunctionVersionLatestPublished publishTo) {
            this.publishTo(publishTo == null ? null : publishTo.toString());
            return this;
        }

        public final TenancyConfig.Builder getTenancyConfig() {
            return this.tenancyConfig != null ? this.tenancyConfig.toBuilder() : null;
        }

        public final void setTenancyConfig(TenancyConfig.BuilderImpl tenancyConfig) {
            this.tenancyConfig = tenancyConfig != null ? tenancyConfig.build() : null;
        }

        @Override
        public final Builder tenancyConfig(TenancyConfig tenancyConfig) {
            this.tenancyConfig = tenancyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionRequest build() {
            return new CreateFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFunctionRequest> {
        public Builder functionName(String var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder code(FunctionCode var1);

        default public Builder code(Consumer<FunctionCode.Builder> code) {
            return this.code((FunctionCode)((FunctionCode.Builder)FunctionCode.builder().applyMutation(code)).build());
        }

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder publish(Boolean var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder environment(Environment var1);

        default public Builder environment(Consumer<Environment.Builder> environment) {
            return this.environment((Environment)((Environment.Builder)Environment.builder().applyMutation(environment)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfig var1);

        default public Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfig)((TracingConfig.Builder)TracingConfig.builder().applyMutation(tracingConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder layers(Collection<String> var1);

        public Builder layers(String ... var1);

        public Builder fileSystemConfigs(Collection<FileSystemConfig> var1);

        public Builder fileSystemConfigs(FileSystemConfig ... var1);

        public Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... var1);

        public Builder imageConfig(ImageConfig var1);

        default public Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return this.imageConfig((ImageConfig)((ImageConfig.Builder)ImageConfig.builder().applyMutation(imageConfig)).build());
        }

        public Builder codeSigningConfigArn(String var1);

        public Builder architecturesWithStrings(Collection<String> var1);

        public Builder architecturesWithStrings(String ... var1);

        public Builder architectures(Collection<Architecture> var1);

        public Builder architectures(Architecture ... var1);

        public Builder ephemeralStorage(EphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EphemeralStorage)((EphemeralStorage.Builder)EphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }

        public Builder snapStart(SnapStart var1);

        default public Builder snapStart(Consumer<SnapStart.Builder> snapStart) {
            return this.snapStart((SnapStart)((SnapStart.Builder)SnapStart.builder().applyMutation(snapStart)).build());
        }

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder capacityProviderConfig(CapacityProviderConfig var1);

        default public Builder capacityProviderConfig(Consumer<CapacityProviderConfig.Builder> capacityProviderConfig) {
            return this.capacityProviderConfig((CapacityProviderConfig)((CapacityProviderConfig.Builder)CapacityProviderConfig.builder().applyMutation(capacityProviderConfig)).build());
        }

        public Builder publishTo(String var1);

        public Builder publishTo(FunctionVersionLatestPublished var1);

        public Builder tenancyConfig(TenancyConfig var1);

        default public Builder tenancyConfig(Consumer<TenancyConfig.Builder> tenancyConfig) {
            return this.tenancyConfig((TenancyConfig)((TenancyConfig.Builder)TenancyConfig.builder().applyMutation(tenancyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

