/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonManagedKafkaEventSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonManagedKafkaEventSourceConfig.Builder, AmazonManagedKafkaEventSourceConfig> {
    private static final SdkField<String> CONSUMER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerGroupId").getter(getter(AmazonManagedKafkaEventSourceConfig::consumerGroupId))
            .setter(setter(Builder::consumerGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerGroupId").build()).build();

    private static final SdkField<KafkaSchemaRegistryConfig> SCHEMA_REGISTRY_CONFIG_FIELD = SdkField
            .<KafkaSchemaRegistryConfig> builder(MarshallingType.SDK_POJO).memberName("SchemaRegistryConfig")
            .getter(getter(AmazonManagedKafkaEventSourceConfig::schemaRegistryConfig))
            .setter(setter(Builder::schemaRegistryConfig)).constructor(KafkaSchemaRegistryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaRegistryConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_GROUP_ID_FIELD,
            SCHEMA_REGISTRY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String consumerGroupId;

    private final KafkaSchemaRegistryConfig schemaRegistryConfig;

    private AmazonManagedKafkaEventSourceConfig(BuilderImpl builder) {
        this.consumerGroupId = builder.consumerGroupId;
        this.schemaRegistryConfig = builder.schemaRegistryConfig;
    }

    /**
     * <p>
     * The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka
     * event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot
     * update this value. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">Customizable
     * consumer group ID</a>.
     * </p>
     * 
     * @return The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your
     *         Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified,
     *         you cannot update this value. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id"
     *         >Customizable consumer group ID</a>.
     */
    public final String consumerGroupId() {
        return consumerGroupId;
    }

    /**
     * <p>
     * Specific configuration settings for a Kafka schema registry.
     * </p>
     * 
     * @return Specific configuration settings for a Kafka schema registry.
     */
    public final KafkaSchemaRegistryConfig schemaRegistryConfig() {
        return schemaRegistryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaRegistryConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonManagedKafkaEventSourceConfig)) {
            return false;
        }
        AmazonManagedKafkaEventSourceConfig other = (AmazonManagedKafkaEventSourceConfig) obj;
        return Objects.equals(consumerGroupId(), other.consumerGroupId())
                && Objects.equals(schemaRegistryConfig(), other.schemaRegistryConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonManagedKafkaEventSourceConfig").add("ConsumerGroupId", consumerGroupId())
                .add("SchemaRegistryConfig", schemaRegistryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerGroupId":
            return Optional.ofNullable(clazz.cast(consumerGroupId()));
        case "SchemaRegistryConfig":
            return Optional.ofNullable(clazz.cast(schemaRegistryConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConsumerGroupId", CONSUMER_GROUP_ID_FIELD);
        map.put("SchemaRegistryConfig", SCHEMA_REGISTRY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonManagedKafkaEventSourceConfig, T> g) {
        return obj -> g.apply((AmazonManagedKafkaEventSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonManagedKafkaEventSourceConfig> {
        /**
         * <p>
         * The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your
         * Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you
         * cannot update this value. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">Customizable
         * consumer group ID</a>.
         * </p>
         * 
         * @param consumerGroupId
         *        The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all
         *        your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID
         *        specified, you cannot update this value. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id"
         *        >Customizable consumer group ID</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupId(String consumerGroupId);

        /**
         * <p>
         * Specific configuration settings for a Kafka schema registry.
         * </p>
         * 
         * @param schemaRegistryConfig
         *        Specific configuration settings for a Kafka schema registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaRegistryConfig(KafkaSchemaRegistryConfig schemaRegistryConfig);

        /**
         * <p>
         * Specific configuration settings for a Kafka schema registry.
         * </p>
         * This is a convenience method that creates an instance of the {@link KafkaSchemaRegistryConfig.Builder}
         * avoiding the need to create one manually via {@link KafkaSchemaRegistryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KafkaSchemaRegistryConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaRegistryConfig(KafkaSchemaRegistryConfig)}.
         * 
         * @param schemaRegistryConfig
         *        a consumer that will call methods on {@link KafkaSchemaRegistryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaRegistryConfig(KafkaSchemaRegistryConfig)
         */
        default Builder schemaRegistryConfig(Consumer<KafkaSchemaRegistryConfig.Builder> schemaRegistryConfig) {
            return schemaRegistryConfig(KafkaSchemaRegistryConfig.builder().applyMutation(schemaRegistryConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String consumerGroupId;

        private KafkaSchemaRegistryConfig schemaRegistryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonManagedKafkaEventSourceConfig model) {
            consumerGroupId(model.consumerGroupId);
            schemaRegistryConfig(model.schemaRegistryConfig);
        }

        public final String getConsumerGroupId() {
            return consumerGroupId;
        }

        public final void setConsumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
        }

        @Override
        public final Builder consumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        public final KafkaSchemaRegistryConfig.Builder getSchemaRegistryConfig() {
            return schemaRegistryConfig != null ? schemaRegistryConfig.toBuilder() : null;
        }

        public final void setSchemaRegistryConfig(KafkaSchemaRegistryConfig.BuilderImpl schemaRegistryConfig) {
            this.schemaRegistryConfig = schemaRegistryConfig != null ? schemaRegistryConfig.build() : null;
        }

        @Override
        public final Builder schemaRegistryConfig(KafkaSchemaRegistryConfig schemaRegistryConfig) {
            this.schemaRegistryConfig = schemaRegistryConfig;
            return this;
        }

        @Override
        public AmazonManagedKafkaEventSourceConfig build() {
            return new AmazonManagedKafkaEventSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
