/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionUrlConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<GetFunctionUrlConfigResponse.Builder, GetFunctionUrlConfigResponse> {
    private static final SdkField<String> FUNCTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionUrl").getter(getter(GetFunctionUrlConfigResponse::functionUrl))
            .setter(setter(Builder::functionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionUrl").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(GetFunctionUrlConfigResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(GetFunctionUrlConfigResponse::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<Cors> CORS_FIELD = SdkField.<Cors> builder(MarshallingType.SDK_POJO).memberName("Cors")
            .getter(getter(GetFunctionUrlConfigResponse::cors)).setter(setter(Builder::cors)).constructor(Cors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cors").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(GetFunctionUrlConfigResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedTime").getter(getter(GetFunctionUrlConfigResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> INVOKE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvokeMode").getter(getter(GetFunctionUrlConfigResponse::invokeModeAsString))
            .setter(setter(Builder::invokeMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokeMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_URL_FIELD,
            FUNCTION_ARN_FIELD, AUTH_TYPE_FIELD, CORS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, INVOKE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String functionUrl;

    private final String functionArn;

    private final String authType;

    private final Cors cors;

    private final String creationTime;

    private final String lastModifiedTime;

    private final String invokeMode;

    private GetFunctionUrlConfigResponse(BuilderImpl builder) {
        super(builder);
        this.functionUrl = builder.functionUrl;
        this.functionArn = builder.functionArn;
        this.authType = builder.authType;
        this.cors = builder.cors;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.invokeMode = builder.invokeMode;
    }

    /**
     * <p>
     * The HTTP URL endpoint for your function.
     * </p>
     * 
     * @return The HTTP URL endpoint for your function.
     */
    public final String functionUrl() {
        return functionUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
     * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a
     * public endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function
     * URLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link FunctionUrlAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
     *         restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
     *         authentication to create a public endpoint. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
     *         function URLs</a>.
     * @see FunctionUrlAuthType
     */
    public final FunctionUrlAuthType authType() {
        return FunctionUrlAuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
     * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a
     * public endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function
     * URLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link FunctionUrlAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
     *         restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
     *         authentication to create a public endpoint. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
     *         function URLs</a>.
     * @see FunctionUrlAuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
     * settings for your function URL.
     * </p>
     * 
     * @return The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing
     *         (CORS)</a> settings for your function URL.
     */
    public final Cors cors() {
        return cors;
    }

    /**
     * <p>
     * When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     *         (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the function URL configuration was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return When the function URL configuration was last updated, in <a
     *         href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final String lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code>
     * API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
     * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is
     * 20 MB, however, you can <a
     * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
     * increase</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invokeMode} will
     * return {@link InvokeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokeModeAsString}.
     * </p>
     * 
     * @return Use one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
     *         <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
     *         maximum payload size is 6 MB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
     *         invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response
     *         payload size is 20 MB, however, you can <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a
     *         quota increase</a>.
     *         </p>
     *         </li>
     * @see InvokeMode
     */
    public final InvokeMode invokeMode() {
        return InvokeMode.fromValue(invokeMode);
    }

    /**
     * <p>
     * Use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code>
     * API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
     * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is
     * 20 MB, however, you can <a
     * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
     * increase</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invokeMode} will
     * return {@link InvokeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokeModeAsString}.
     * </p>
     * 
     * @return Use one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
     *         <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
     *         maximum payload size is 6 MB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
     *         invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response
     *         payload size is 20 MB, however, you can <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a
     *         quota increase</a>.
     *         </p>
     *         </li>
     * @see InvokeMode
     */
    public final String invokeModeAsString() {
        return invokeMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cors());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(invokeModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionUrlConfigResponse)) {
            return false;
        }
        GetFunctionUrlConfigResponse other = (GetFunctionUrlConfigResponse) obj;
        return Objects.equals(functionUrl(), other.functionUrl()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(authTypeAsString(), other.authTypeAsString()) && Objects.equals(cors(), other.cors())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(invokeModeAsString(), other.invokeModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionUrlConfigResponse").add("FunctionUrl", functionUrl())
                .add("FunctionArn", functionArn()).add("AuthType", authTypeAsString()).add("Cors", cors())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("InvokeMode", invokeModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionUrl":
            return Optional.ofNullable(clazz.cast(functionUrl()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "Cors":
            return Optional.ofNullable(clazz.cast(cors()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "InvokeMode":
            return Optional.ofNullable(clazz.cast(invokeModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionUrl", FUNCTION_URL_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("Cors", CORS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("InvokeMode", INVOKE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionUrlConfigResponse, T> g) {
        return obj -> g.apply((GetFunctionUrlConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionUrlConfigResponse> {
        /**
         * <p>
         * The HTTP URL endpoint for your function.
         * </p>
         * 
         * @param functionUrl
         *        The HTTP URL endpoint for your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionUrl(String functionUrl);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your function.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
         * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to
         * create a public endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         * function URLs</a>.
         * </p>
         * 
         * @param authType
         *        The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
         *        restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
         *        authentication to create a public endpoint. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         *        function URLs</a>.
         * @see FunctionUrlAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionUrlAuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
         * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to
         * create a public endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         * function URLs</a>.
         * </p>
         * 
         * @param authType
         *        The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
         *        restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
         *        authentication to create a public endpoint. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         *        function URLs</a>.
         * @see FunctionUrlAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionUrlAuthType
         */
        Builder authType(FunctionUrlAuthType authType);

        /**
         * <p>
         * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
         * settings for your function URL.
         * </p>
         * 
         * @param cors
         *        The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing
         *        (CORS)</a> settings for your function URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cors(Cors cors);

        /**
         * <p>
         * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
         * settings for your function URL.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cors.Builder} avoiding the need to create
         * one manually via {@link Cors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cors.Builder#build()} is called immediately and its result is
         * passed to {@link #cors(Cors)}.
         * 
         * @param cors
         *        a consumer that will call methods on {@link Cors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cors(Cors)
         */
        default Builder cors(Consumer<Cors.Builder> cors) {
            return cors(Cors.builder().applyMutation(cors).build());
        }

        /**
         * <p>
         * When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
         * (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param creationTime
         *        When the function URL was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         *        format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * When the function URL configuration was last updated, in <a
         * href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param lastModifiedTime
         *        When the function URL configuration was last updated, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(String lastModifiedTime);

        /**
         * <p>
         * Use one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         * <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum
         * payload size is 6 MB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
         * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload
         * size is 20 MB, however, you can <a
         * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
         * increase</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invokeMode
         *        Use one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         *        <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
         *        maximum payload size is 6 MB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
         *        invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum
         *        response payload size is 20 MB, however, you can <a
         *        href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request
         *        a quota increase</a>.
         *        </p>
         *        </li>
         * @see InvokeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvokeMode
         */
        Builder invokeMode(String invokeMode);

        /**
         * <p>
         * Use one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         * <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum
         * payload size is 6 MB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
         * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload
         * size is 20 MB, however, you can <a
         * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
         * increase</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invokeMode
         *        Use one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         *        <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
         *        maximum payload size is 6 MB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
         *        invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum
         *        response payload size is 20 MB, however, you can <a
         *        href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request
         *        a quota increase</a>.
         *        </p>
         *        </li>
         * @see InvokeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvokeMode
         */
        Builder invokeMode(InvokeMode invokeMode);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String functionUrl;

        private String functionArn;

        private String authType;

        private Cors cors;

        private String creationTime;

        private String lastModifiedTime;

        private String invokeMode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionUrlConfigResponse model) {
            super(model);
            functionUrl(model.functionUrl);
            functionArn(model.functionArn);
            authType(model.authType);
            cors(model.cors);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            invokeMode(model.invokeMode);
        }

        public final String getFunctionUrl() {
            return functionUrl;
        }

        public final void setFunctionUrl(String functionUrl) {
            this.functionUrl = functionUrl;
        }

        @Override
        public final Builder functionUrl(String functionUrl) {
            this.functionUrl = functionUrl;
            return this;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(FunctionUrlAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Cors.Builder getCors() {
            return cors != null ? cors.toBuilder() : null;
        }

        public final void setCors(Cors.BuilderImpl cors) {
            this.cors = cors != null ? cors.build() : null;
        }

        @Override
        public final Builder cors(Cors cors) {
            this.cors = cors;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getInvokeMode() {
            return invokeMode;
        }

        public final void setInvokeMode(String invokeMode) {
            this.invokeMode = invokeMode;
        }

        @Override
        public final Builder invokeMode(String invokeMode) {
            this.invokeMode = invokeMode;
            return this;
        }

        @Override
        public final Builder invokeMode(InvokeMode invokeMode) {
            this.invokeMode(invokeMode == null ? null : invokeMode.toString());
            return this;
        }

        @Override
        public GetFunctionUrlConfigResponse build() {
            return new GetFunctionUrlConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
