/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicAccessBlockConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicAccessBlockConfig> {
    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BlockPublicPolicy").getter(PublicAccessBlockConfig.getter(PublicAccessBlockConfig::blockPublicPolicy)).setter(PublicAccessBlockConfig.setter(Builder::blockPublicPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicPolicy").build()}).build();
    private static final SdkField<Boolean> RESTRICT_PUBLIC_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RestrictPublicResource").getter(PublicAccessBlockConfig.getter(PublicAccessBlockConfig::restrictPublicResource)).setter(PublicAccessBlockConfig.setter(Builder::restrictPublicResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictPublicResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_PUBLIC_POLICY_FIELD, RESTRICT_PUBLIC_RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean blockPublicPolicy;
    private final Boolean restrictPublicResource;

    private PublicAccessBlockConfig(BuilderImpl builder) {
        this.blockPublicPolicy = builder.blockPublicPolicy;
        this.restrictPublicResource = builder.restrictPublicResource;
    }

    public final Boolean blockPublicPolicy() {
        return this.blockPublicPolicy;
    }

    public final Boolean restrictPublicResource() {
        return this.restrictPublicResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictPublicResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicAccessBlockConfig)) {
            return false;
        }
        PublicAccessBlockConfig other = (PublicAccessBlockConfig)obj;
        return Objects.equals(this.blockPublicPolicy(), other.blockPublicPolicy()) && Objects.equals(this.restrictPublicResource(), other.restrictPublicResource());
    }

    public final String toString() {
        return ToString.builder((String)"PublicAccessBlockConfig").add("BlockPublicPolicy", (Object)this.blockPublicPolicy()).add("RestrictPublicResource", (Object)this.restrictPublicResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockPublicPolicy": {
                return Optional.ofNullable(clazz.cast(this.blockPublicPolicy()));
            }
            case "RestrictPublicResource": {
                return Optional.ofNullable(clazz.cast(this.restrictPublicResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicAccessBlockConfig, T> g) {
        return obj -> g.apply((PublicAccessBlockConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean blockPublicPolicy;
        private Boolean restrictPublicResource;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicAccessBlockConfig model) {
            this.blockPublicPolicy(model.blockPublicPolicy);
            this.restrictPublicResource(model.restrictPublicResource);
        }

        public final Boolean getBlockPublicPolicy() {
            return this.blockPublicPolicy;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        public final Boolean getRestrictPublicResource() {
            return this.restrictPublicResource;
        }

        public final void setRestrictPublicResource(Boolean restrictPublicResource) {
            this.restrictPublicResource = restrictPublicResource;
        }

        @Override
        public final Builder restrictPublicResource(Boolean restrictPublicResource) {
            this.restrictPublicResource = restrictPublicResource;
            return this;
        }

        public PublicAccessBlockConfig build() {
            return new PublicAccessBlockConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicAccessBlockConfig> {
        public Builder blockPublicPolicy(Boolean var1);

        public Builder restrictPublicResource(Boolean var1);
    }
}

