/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig;
import software.amazon.awssdk.services.lambda.model.DestinationConfig;
import software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig;
import software.amazon.awssdk.services.lambda.model.EventSourcePosition;
import software.amazon.awssdk.services.lambda.model.FilterCriteria;
import software.amazon.awssdk.services.lambda.model.FunctionResponseType;
import software.amazon.awssdk.services.lambda.model.FunctionResponseTypeListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.QueuesCopier;
import software.amazon.awssdk.services.lambda.model.ScalingConfig;
import software.amazon.awssdk.services.lambda.model.SelfManagedEventSource;
import software.amazon.awssdk.services.lambda.model.SelfManagedKafkaEventSourceConfig;
import software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration;
import software.amazon.awssdk.services.lambda.model.SourceAccessConfigurationsCopier;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.services.lambda.model.TopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventSourceMappingRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateEventSourceMappingRequest> {
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::eventSourceArn)).setter(CreateEventSourceMappingRequest.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::functionName)).setter(CreateEventSourceMappingRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::enabled)).setter(CreateEventSourceMappingRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::batchSize)).setter(CreateEventSourceMappingRequest.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::filterCriteria)).setter(CreateEventSourceMappingRequest.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::maximumBatchingWindowInSeconds)).setter(CreateEventSourceMappingRequest.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelizationFactor").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::parallelizationFactor)).setter(CreateEventSourceMappingRequest.setter(Builder::parallelizationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::startingPositionAsString)).setter(CreateEventSourceMappingRequest.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<Instant> STARTING_POSITION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartingPositionTimestamp").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::startingPositionTimestamp)).setter(CreateEventSourceMappingRequest.setter(Builder::startingPositionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPositionTimestamp").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfig").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::destinationConfig)).setter(CreateEventSourceMappingRequest.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::maximumRecordAgeInSeconds)).setter(CreateEventSourceMappingRequest.setter(Builder::maximumRecordAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build()}).build();
    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BisectBatchOnFunctionError").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::bisectBatchOnFunctionError)).setter(CreateEventSourceMappingRequest.setter(Builder::bisectBatchOnFunctionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::maximumRetryAttempts)).setter(CreateEventSourceMappingRequest.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::tags)).setter(CreateEventSourceMappingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TUMBLING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TumblingWindowInSeconds").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::tumblingWindowInSeconds)).setter(CreateEventSourceMappingRequest.setter(Builder::tumblingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TumblingWindowInSeconds").build()}).build();
    private static final SdkField<List<String>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Topics").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::topics)).setter(CreateEventSourceMappingRequest.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::queues)).setter(CreateEventSourceMappingRequest.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SourceAccessConfiguration>> SOURCE_ACCESS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAccessConfigurations").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::sourceAccessConfigurations)).setter(CreateEventSourceMappingRequest.setter(Builder::sourceAccessConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccessConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SelfManagedEventSource> SELF_MANAGED_EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedEventSource").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::selfManagedEventSource)).setter(CreateEventSourceMappingRequest.setter(Builder::selfManagedEventSource)).constructor(SelfManagedEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedEventSource").build()}).build();
    private static final SdkField<List<String>> FUNCTION_RESPONSE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionResponseTypes").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::functionResponseTypesAsStrings)).setter(CreateEventSourceMappingRequest.setter(Builder::functionResponseTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionResponseTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AmazonManagedKafkaEventSourceConfig> AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonManagedKafkaEventSourceConfig").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::amazonManagedKafkaEventSourceConfig)).setter(CreateEventSourceMappingRequest.setter(Builder::amazonManagedKafkaEventSourceConfig)).constructor(AmazonManagedKafkaEventSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonManagedKafkaEventSourceConfig").build()}).build();
    private static final SdkField<SelfManagedKafkaEventSourceConfig> SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedKafkaEventSourceConfig").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::selfManagedKafkaEventSourceConfig)).setter(CreateEventSourceMappingRequest.setter(Builder::selfManagedKafkaEventSourceConfig)).constructor(SelfManagedKafkaEventSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaEventSourceConfig").build()}).build();
    private static final SdkField<ScalingConfig> SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingConfig").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::scalingConfig)).setter(CreateEventSourceMappingRequest.setter(Builder::scalingConfig)).constructor(ScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfig").build()}).build();
    private static final SdkField<DocumentDBEventSourceConfig> DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentDBEventSourceConfig").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::documentDBEventSourceConfig)).setter(CreateEventSourceMappingRequest.setter(Builder::documentDBEventSourceConfig)).constructor(DocumentDBEventSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDBEventSourceConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyArn").getter(CreateEventSourceMappingRequest.getter(CreateEventSourceMappingRequest::kmsKeyArn)).setter(CreateEventSourceMappingRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_ARN_FIELD, FUNCTION_NAME_FIELD, ENABLED_FIELD, BATCH_SIZE_FIELD, FILTER_CRITERIA_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, PARALLELIZATION_FACTOR_FIELD, STARTING_POSITION_FIELD, STARTING_POSITION_TIMESTAMP_FIELD, DESTINATION_CONFIG_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, BISECT_BATCH_ON_FUNCTION_ERROR_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, TAGS_FIELD, TUMBLING_WINDOW_IN_SECONDS_FIELD, TOPICS_FIELD, QUEUES_FIELD, SOURCE_ACCESS_CONFIGURATIONS_FIELD, SELF_MANAGED_EVENT_SOURCE_FIELD, FUNCTION_RESPONSE_TYPES_FIELD, AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD, SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD, SCALING_CONFIG_FIELD, DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD, KMS_KEY_ARN_FIELD));
    private final String eventSourceArn;
    private final String functionName;
    private final Boolean enabled;
    private final Integer batchSize;
    private final FilterCriteria filterCriteria;
    private final Integer maximumBatchingWindowInSeconds;
    private final Integer parallelizationFactor;
    private final String startingPosition;
    private final Instant startingPositionTimestamp;
    private final DestinationConfig destinationConfig;
    private final Integer maximumRecordAgeInSeconds;
    private final Boolean bisectBatchOnFunctionError;
    private final Integer maximumRetryAttempts;
    private final Map<String, String> tags;
    private final Integer tumblingWindowInSeconds;
    private final List<String> topics;
    private final List<String> queues;
    private final List<SourceAccessConfiguration> sourceAccessConfigurations;
    private final SelfManagedEventSource selfManagedEventSource;
    private final List<String> functionResponseTypes;
    private final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;
    private final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;
    private final ScalingConfig scalingConfig;
    private final DocumentDBEventSourceConfig documentDBEventSourceConfig;
    private final String kmsKeyArn;

    private CreateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.eventSourceArn = builder.eventSourceArn;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.filterCriteria = builder.filterCriteria;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
        this.destinationConfig = builder.destinationConfig;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.tags = builder.tags;
        this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        this.topics = builder.topics;
        this.queues = builder.queues;
        this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
        this.selfManagedEventSource = builder.selfManagedEventSource;
        this.functionResponseTypes = builder.functionResponseTypes;
        this.amazonManagedKafkaEventSourceConfig = builder.amazonManagedKafkaEventSourceConfig;
        this.selfManagedKafkaEventSourceConfig = builder.selfManagedKafkaEventSourceConfig;
        this.scalingConfig = builder.scalingConfig;
        this.documentDBEventSourceConfig = builder.documentDBEventSourceConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String eventSourceArn() {
        return this.eventSourceArn;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final Integer parallelizationFactor() {
        return this.parallelizationFactor;
    }

    public final EventSourcePosition startingPosition() {
        return EventSourcePosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final Instant startingPositionTimestamp() {
        return this.startingPositionTimestamp;
    }

    public final DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public final Integer maximumRecordAgeInSeconds() {
        return this.maximumRecordAgeInSeconds;
    }

    public final Boolean bisectBatchOnFunctionError() {
        return this.bisectBatchOnFunctionError;
    }

    public final Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer tumblingWindowInSeconds() {
        return this.tumblingWindowInSeconds;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<String> topics() {
        return this.topics;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<String> queues() {
        return this.queues;
    }

    public final boolean hasSourceAccessConfigurations() {
        return this.sourceAccessConfigurations != null && !(this.sourceAccessConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SourceAccessConfiguration> sourceAccessConfigurations() {
        return this.sourceAccessConfigurations;
    }

    public final SelfManagedEventSource selfManagedEventSource() {
        return this.selfManagedEventSource;
    }

    public final List<FunctionResponseType> functionResponseTypes() {
        return FunctionResponseTypeListCopier.copyStringToEnum(this.functionResponseTypes);
    }

    public final boolean hasFunctionResponseTypes() {
        return this.functionResponseTypes != null && !(this.functionResponseTypes instanceof SdkAutoConstructList);
    }

    public final List<String> functionResponseTypesAsStrings() {
        return this.functionResponseTypes;
    }

    public final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig() {
        return this.amazonManagedKafkaEventSourceConfig;
    }

    public final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig() {
        return this.selfManagedKafkaEventSourceConfig;
    }

    public final ScalingConfig scalingConfig() {
        return this.scalingConfig;
    }

    public final DocumentDBEventSourceConfig documentDBEventSourceConfig() {
        return this.documentDBEventSourceConfig;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tumblingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAccessConfigurations() ? this.sourceAccessConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionResponseTypes() ? this.functionResponseTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDBEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSourceMappingRequest)) {
            return false;
        }
        CreateEventSourceMappingRequest other = (CreateEventSourceMappingRequest)((Object)obj);
        return Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.parallelizationFactor(), other.parallelizationFactor()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.startingPositionTimestamp(), other.startingPositionTimestamp()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && Objects.equals(this.maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds()) && Objects.equals(this.bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tumblingWindowInSeconds(), other.tumblingWindowInSeconds()) && this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics()) && this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && this.hasSourceAccessConfigurations() == other.hasSourceAccessConfigurations() && Objects.equals(this.sourceAccessConfigurations(), other.sourceAccessConfigurations()) && Objects.equals(this.selfManagedEventSource(), other.selfManagedEventSource()) && this.hasFunctionResponseTypes() == other.hasFunctionResponseTypes() && Objects.equals(this.functionResponseTypesAsStrings(), other.functionResponseTypesAsStrings()) && Objects.equals(this.amazonManagedKafkaEventSourceConfig(), other.amazonManagedKafkaEventSourceConfig()) && Objects.equals(this.selfManagedKafkaEventSourceConfig(), other.selfManagedKafkaEventSourceConfig()) && Objects.equals(this.scalingConfig(), other.scalingConfig()) && Objects.equals(this.documentDBEventSourceConfig(), other.documentDBEventSourceConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEventSourceMappingRequest").add("EventSourceArn", (Object)this.eventSourceArn()).add("FunctionName", (Object)this.functionName()).add("Enabled", (Object)this.enabled()).add("BatchSize", (Object)this.batchSize()).add("FilterCriteria", (Object)this.filterCriteria()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("ParallelizationFactor", (Object)this.parallelizationFactor()).add("StartingPosition", (Object)this.startingPositionAsString()).add("StartingPositionTimestamp", (Object)this.startingPositionTimestamp()).add("DestinationConfig", (Object)this.destinationConfig()).add("MaximumRecordAgeInSeconds", (Object)this.maximumRecordAgeInSeconds()).add("BisectBatchOnFunctionError", (Object)this.bisectBatchOnFunctionError()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("Tags", this.hasTags() ? this.tags() : null).add("TumblingWindowInSeconds", (Object)this.tumblingWindowInSeconds()).add("Topics", this.hasTopics() ? this.topics() : null).add("Queues", this.hasQueues() ? this.queues() : null).add("SourceAccessConfigurations", this.hasSourceAccessConfigurations() ? this.sourceAccessConfigurations() : null).add("SelfManagedEventSource", (Object)this.selfManagedEventSource()).add("FunctionResponseTypes", this.hasFunctionResponseTypes() ? this.functionResponseTypesAsStrings() : null).add("AmazonManagedKafkaEventSourceConfig", (Object)this.amazonManagedKafkaEventSourceConfig()).add("SelfManagedKafkaEventSourceConfig", (Object)this.selfManagedKafkaEventSourceConfig()).add("ScalingConfig", (Object)this.scalingConfig()).add("DocumentDBEventSourceConfig", (Object)this.documentDBEventSourceConfig()).add("KMSKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "ParallelizationFactor": {
                return Optional.ofNullable(clazz.cast(this.parallelizationFactor()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "StartingPositionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startingPositionTimestamp()));
            }
            case "DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "MaximumRecordAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumRecordAgeInSeconds()));
            }
            case "BisectBatchOnFunctionError": {
                return Optional.ofNullable(clazz.cast(this.bisectBatchOnFunctionError()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TumblingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.tumblingWindowInSeconds()));
            }
            case "Topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "SourceAccessConfigurations": {
                return Optional.ofNullable(clazz.cast(this.sourceAccessConfigurations()));
            }
            case "SelfManagedEventSource": {
                return Optional.ofNullable(clazz.cast(this.selfManagedEventSource()));
            }
            case "FunctionResponseTypes": {
                return Optional.ofNullable(clazz.cast(this.functionResponseTypesAsStrings()));
            }
            case "AmazonManagedKafkaEventSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.amazonManagedKafkaEventSourceConfig()));
            }
            case "SelfManagedKafkaEventSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.selfManagedKafkaEventSourceConfig()));
            }
            case "ScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.scalingConfig()));
            }
            case "DocumentDBEventSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.documentDBEventSourceConfig()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSourceMappingRequest, T> g) {
        return obj -> g.apply((CreateEventSourceMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String eventSourceArn;
        private String functionName;
        private Boolean enabled;
        private Integer batchSize;
        private FilterCriteria filterCriteria;
        private Integer maximumBatchingWindowInSeconds;
        private Integer parallelizationFactor;
        private String startingPosition;
        private Instant startingPositionTimestamp;
        private DestinationConfig destinationConfig;
        private Integer maximumRecordAgeInSeconds;
        private Boolean bisectBatchOnFunctionError;
        private Integer maximumRetryAttempts;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer tumblingWindowInSeconds;
        private List<String> topics = DefaultSdkAutoConstructList.getInstance();
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();
        private List<SourceAccessConfiguration> sourceAccessConfigurations = DefaultSdkAutoConstructList.getInstance();
        private SelfManagedEventSource selfManagedEventSource;
        private List<String> functionResponseTypes = DefaultSdkAutoConstructList.getInstance();
        private AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;
        private SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;
        private ScalingConfig scalingConfig;
        private DocumentDBEventSourceConfig documentDBEventSourceConfig;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSourceMappingRequest model) {
            super(model);
            this.eventSourceArn(model.eventSourceArn);
            this.functionName(model.functionName);
            this.enabled(model.enabled);
            this.batchSize(model.batchSize);
            this.filterCriteria(model.filterCriteria);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.parallelizationFactor(model.parallelizationFactor);
            this.startingPosition(model.startingPosition);
            this.startingPositionTimestamp(model.startingPositionTimestamp);
            this.destinationConfig(model.destinationConfig);
            this.maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            this.bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.tags(model.tags);
            this.tumblingWindowInSeconds(model.tumblingWindowInSeconds);
            this.topics(model.topics);
            this.queues(model.queues);
            this.sourceAccessConfigurations(model.sourceAccessConfigurations);
            this.selfManagedEventSource(model.selfManagedEventSource);
            this.functionResponseTypesWithStrings(model.functionResponseTypes);
            this.amazonManagedKafkaEventSourceConfig(model.amazonManagedKafkaEventSourceConfig);
            this.selfManagedKafkaEventSourceConfig(model.selfManagedKafkaEventSourceConfig);
            this.scalingConfig(model.scalingConfig);
            this.documentDBEventSourceConfig(model.documentDBEventSourceConfig);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Instant getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return this.bisectBatchOnFunctionError;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Integer getTumblingWindowInSeconds() {
            return this.tumblingWindowInSeconds;
        }

        public final void setTumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
        }

        @Override
        public final Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        public final Collection<String> getTopics() {
            if (this.topics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topics;
        }

        public final void setTopics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
        }

        @Override
        public final Builder topics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(String ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        public final Collection<String> getQueues() {
            if (this.queues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final List<SourceAccessConfiguration.Builder> getSourceAccessConfigurations() {
            List<SourceAccessConfiguration.Builder> result = SourceAccessConfigurationsCopier.copyToBuilder(this.sourceAccessConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAccessConfigurations(Collection<SourceAccessConfiguration.BuilderImpl> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copyFromBuilder(sourceAccessConfigurations);
        }

        @Override
        public final Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copy(sourceAccessConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(SourceAccessConfiguration ... sourceAccessConfigurations) {
            this.sourceAccessConfigurations(Arrays.asList(sourceAccessConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder> ... sourceAccessConfigurations) {
            this.sourceAccessConfigurations(Stream.of(sourceAccessConfigurations).map(c -> (SourceAccessConfiguration)((SourceAccessConfiguration.Builder)SourceAccessConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SelfManagedEventSource.Builder getSelfManagedEventSource() {
            return this.selfManagedEventSource != null ? this.selfManagedEventSource.toBuilder() : null;
        }

        public final void setSelfManagedEventSource(SelfManagedEventSource.BuilderImpl selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource != null ? selfManagedEventSource.build() : null;
        }

        @Override
        public final Builder selfManagedEventSource(SelfManagedEventSource selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        public final Collection<String> getFunctionResponseTypes() {
            if (this.functionResponseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functionResponseTypes;
        }

        public final void setFunctionResponseTypes(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
        }

        @Override
        public final Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypesWithStrings(String ... functionResponseTypes) {
            this.functionResponseTypesWithStrings(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        public final Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copyEnumToString(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypes(FunctionResponseType ... functionResponseTypes) {
            this.functionResponseTypes(Arrays.asList(functionResponseTypes));
            return this;
        }

        public final AmazonManagedKafkaEventSourceConfig.Builder getAmazonManagedKafkaEventSourceConfig() {
            return this.amazonManagedKafkaEventSourceConfig != null ? this.amazonManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setAmazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig.BuilderImpl amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig != null ? amazonManagedKafkaEventSourceConfig.build() : null;
        }

        @Override
        public final Builder amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        public final SelfManagedKafkaEventSourceConfig.Builder getSelfManagedKafkaEventSourceConfig() {
            return this.selfManagedKafkaEventSourceConfig != null ? this.selfManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setSelfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig.BuilderImpl selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig != null ? selfManagedKafkaEventSourceConfig.build() : null;
        }

        @Override
        public final Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        public final ScalingConfig.Builder getScalingConfig() {
            return this.scalingConfig != null ? this.scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(ScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(ScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final DocumentDBEventSourceConfig.Builder getDocumentDBEventSourceConfig() {
            return this.documentDBEventSourceConfig != null ? this.documentDBEventSourceConfig.toBuilder() : null;
        }

        public final void setDocumentDBEventSourceConfig(DocumentDBEventSourceConfig.BuilderImpl documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig != null ? documentDBEventSourceConfig.build() : null;
        }

        @Override
        public final Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventSourceMappingRequest build() {
            return new CreateEventSourceMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventSourceMappingRequest> {
        public Builder eventSourceArn(String var1);

        public Builder functionName(String var1);

        public Builder enabled(Boolean var1);

        public Builder batchSize(Integer var1);

        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder parallelizationFactor(Integer var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(EventSourcePosition var1);

        public Builder startingPositionTimestamp(Instant var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder maximumRecordAgeInSeconds(Integer var1);

        public Builder bisectBatchOnFunctionError(Boolean var1);

        public Builder maximumRetryAttempts(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder tumblingWindowInSeconds(Integer var1);

        public Builder topics(Collection<String> var1);

        public Builder topics(String ... var1);

        public Builder queues(Collection<String> var1);

        public Builder queues(String ... var1);

        public Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> var1);

        public Builder sourceAccessConfigurations(SourceAccessConfiguration ... var1);

        public Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder> ... var1);

        public Builder selfManagedEventSource(SelfManagedEventSource var1);

        default public Builder selfManagedEventSource(Consumer<SelfManagedEventSource.Builder> selfManagedEventSource) {
            return this.selfManagedEventSource((SelfManagedEventSource)((SelfManagedEventSource.Builder)SelfManagedEventSource.builder().applyMutation(selfManagedEventSource)).build());
        }

        public Builder functionResponseTypesWithStrings(Collection<String> var1);

        public Builder functionResponseTypesWithStrings(String ... var1);

        public Builder functionResponseTypes(Collection<FunctionResponseType> var1);

        public Builder functionResponseTypes(FunctionResponseType ... var1);

        public Builder amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig var1);

        default public Builder amazonManagedKafkaEventSourceConfig(Consumer<AmazonManagedKafkaEventSourceConfig.Builder> amazonManagedKafkaEventSourceConfig) {
            return this.amazonManagedKafkaEventSourceConfig((AmazonManagedKafkaEventSourceConfig)((AmazonManagedKafkaEventSourceConfig.Builder)AmazonManagedKafkaEventSourceConfig.builder().applyMutation(amazonManagedKafkaEventSourceConfig)).build());
        }

        public Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig var1);

        default public Builder selfManagedKafkaEventSourceConfig(Consumer<SelfManagedKafkaEventSourceConfig.Builder> selfManagedKafkaEventSourceConfig) {
            return this.selfManagedKafkaEventSourceConfig((SelfManagedKafkaEventSourceConfig)((SelfManagedKafkaEventSourceConfig.Builder)SelfManagedKafkaEventSourceConfig.builder().applyMutation(selfManagedKafkaEventSourceConfig)).build());
        }

        public Builder scalingConfig(ScalingConfig var1);

        default public Builder scalingConfig(Consumer<ScalingConfig.Builder> scalingConfig) {
            return this.scalingConfig((ScalingConfig)((ScalingConfig.Builder)ScalingConfig.builder().applyMutation(scalingConfig)).build());
        }

        public Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig var1);

        default public Builder documentDBEventSourceConfig(Consumer<DocumentDBEventSourceConfig.Builder> documentDBEventSourceConfig) {
            return this.documentDBEventSourceConfig((DocumentDBEventSourceConfig)((DocumentDBEventSourceConfig.Builder)DocumentDBEventSourceConfig.builder().applyMutation(documentDBEventSourceConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

