/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html">SnapStart</a> setting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapStartResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapStartResponse.Builder, SnapStartResponse> {
    private static final SdkField<String> APPLY_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplyOn").getter(getter(SnapStartResponse::applyOnAsString)).setter(setter(Builder::applyOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOn").build()).build();

    private static final SdkField<String> OPTIMIZATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationStatus").getter(getter(SnapStartResponse::optimizationStatusAsString))
            .setter(setter(Builder::optimizationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLY_ON_FIELD,
            OPTIMIZATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applyOn;

    private final String optimizationStatus;

    private SnapStartResponse(BuilderImpl builder) {
        this.applyOn = builder.applyOn;
        this.optimizationStatus = builder.optimizationStatus;
    }

    /**
     * <p>
     * When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when you
     * publish a function version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyOn} will
     * return {@link SnapStartApplyOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #applyOnAsString}.
     * </p>
     * 
     * @return When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when
     *         you publish a function version.
     * @see SnapStartApplyOn
     */
    public final SnapStartApplyOn applyOn() {
        return SnapStartApplyOn.fromValue(applyOn);
    }

    /**
     * <p>
     * When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when you
     * publish a function version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyOn} will
     * return {@link SnapStartApplyOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #applyOnAsString}.
     * </p>
     * 
     * @return When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when
     *         you publish a function version.
     * @see SnapStartApplyOn
     */
    public final String applyOnAsString() {
        return applyOn;
    }

    /**
     * <p>
     * When you provide a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
     * >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated for the
     * specified function version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationStatus} will return {@link SnapStartOptimizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #optimizationStatusAsString}.
     * </p>
     * 
     * @return When you provide a <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
     *         >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated
     *         for the specified function version.
     * @see SnapStartOptimizationStatus
     */
    public final SnapStartOptimizationStatus optimizationStatus() {
        return SnapStartOptimizationStatus.fromValue(optimizationStatus);
    }

    /**
     * <p>
     * When you provide a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
     * >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated for the
     * specified function version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationStatus} will return {@link SnapStartOptimizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #optimizationStatusAsString}.
     * </p>
     * 
     * @return When you provide a <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
     *         >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated
     *         for the specified function version.
     * @see SnapStartOptimizationStatus
     */
    public final String optimizationStatusAsString() {
        return optimizationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applyOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapStartResponse)) {
            return false;
        }
        SnapStartResponse other = (SnapStartResponse) obj;
        return Objects.equals(applyOnAsString(), other.applyOnAsString())
                && Objects.equals(optimizationStatusAsString(), other.optimizationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapStartResponse").add("ApplyOn", applyOnAsString())
                .add("OptimizationStatus", optimizationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplyOn":
            return Optional.ofNullable(clazz.cast(applyOnAsString()));
        case "OptimizationStatus":
            return Optional.ofNullable(clazz.cast(optimizationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapStartResponse, T> g) {
        return obj -> g.apply((SnapStartResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapStartResponse> {
        /**
         * <p>
         * When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when you
         * publish a function version.
         * </p>
         * 
         * @param applyOn
         *        When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment
         *        when you publish a function version.
         * @see SnapStartApplyOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapStartApplyOn
         */
        Builder applyOn(String applyOn);

        /**
         * <p>
         * When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment when you
         * publish a function version.
         * </p>
         * 
         * @param applyOn
         *        When set to <code>PublishedVersions</code>, Lambda creates a snapshot of the execution environment
         *        when you publish a function version.
         * @see SnapStartApplyOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapStartApplyOn
         */
        Builder applyOn(SnapStartApplyOn applyOn);

        /**
         * <p>
         * When you provide a <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         * >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated for
         * the specified function version.
         * </p>
         * 
         * @param optimizationStatus
         *        When you provide a <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         *        >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is
         *        activated for the specified function version.
         * @see SnapStartOptimizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapStartOptimizationStatus
         */
        Builder optimizationStatus(String optimizationStatus);

        /**
         * <p>
         * When you provide a <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         * >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is activated for
         * the specified function version.
         * </p>
         * 
         * @param optimizationStatus
         *        When you provide a <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using"
         *        >qualified Amazon Resource Name (ARN)</a>, this response element indicates whether SnapStart is
         *        activated for the specified function version.
         * @see SnapStartOptimizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapStartOptimizationStatus
         */
        Builder optimizationStatus(SnapStartOptimizationStatus optimizationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String applyOn;

        private String optimizationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapStartResponse model) {
            applyOn(model.applyOn);
            optimizationStatus(model.optimizationStatus);
        }

        public final String getApplyOn() {
            return applyOn;
        }

        public final void setApplyOn(String applyOn) {
            this.applyOn = applyOn;
        }

        @Override
        public final Builder applyOn(String applyOn) {
            this.applyOn = applyOn;
            return this;
        }

        @Override
        public final Builder applyOn(SnapStartApplyOn applyOn) {
            this.applyOn(applyOn == null ? null : applyOn.toString());
            return this;
        }

        public final String getOptimizationStatus() {
            return optimizationStatus;
        }

        public final void setOptimizationStatus(String optimizationStatus) {
            this.optimizationStatus = optimizationStatus;
        }

        @Override
        public final Builder optimizationStatus(String optimizationStatus) {
            this.optimizationStatus = optimizationStatus;
            return this;
        }

        @Override
        public final Builder optimizationStatus(SnapStartOptimizationStatus optimizationStatus) {
            this.optimizationStatus(optimizationStatus == null ? null : optimizationStatus.toString());
            return this;
        }

        @Override
        public SnapStartResponse build() {
            return new SnapStartResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
