/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayersListItem implements SdkPojo, Serializable, ToCopyableBuilder<LayersListItem.Builder, LayersListItem> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerName").getter(getter(LayersListItem::layerName)).setter(setter(Builder::layerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerName").build()).build();

    private static final SdkField<String> LAYER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerArn").getter(getter(LayersListItem::layerArn)).setter(setter(Builder::layerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerArn").build()).build();

    private static final SdkField<LayerVersionsListItem> LATEST_MATCHING_VERSION_FIELD = SdkField
            .<LayerVersionsListItem> builder(MarshallingType.SDK_POJO).memberName("LatestMatchingVersion")
            .getter(getter(LayersListItem::latestMatchingVersion)).setter(setter(Builder::latestMatchingVersion))
            .constructor(LayerVersionsListItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestMatchingVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD,
            LAYER_ARN_FIELD, LATEST_MATCHING_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String layerName;

    private final String layerArn;

    private final LayerVersionsListItem latestMatchingVersion;

    private LayersListItem(BuilderImpl builder) {
        this.layerName = builder.layerName;
        this.layerArn = builder.layerArn;
        this.latestMatchingVersion = builder.latestMatchingVersion;
    }

    /**
     * <p>
     * The name of the layer.
     * </p>
     * 
     * @return The name of the layer.
     */
    public final String layerName() {
        return layerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function layer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function layer.
     */
    public final String layerArn() {
        return layerArn;
    }

    /**
     * <p>
     * The newest version of the layer.
     * </p>
     * 
     * @return The newest version of the layer.
     */
    public final LayerVersionsListItem latestMatchingVersion() {
        return latestMatchingVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerName());
        hashCode = 31 * hashCode + Objects.hashCode(layerArn());
        hashCode = 31 * hashCode + Objects.hashCode(latestMatchingVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayersListItem)) {
            return false;
        }
        LayersListItem other = (LayersListItem) obj;
        return Objects.equals(layerName(), other.layerName()) && Objects.equals(layerArn(), other.layerArn())
                && Objects.equals(latestMatchingVersion(), other.latestMatchingVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayersListItem").add("LayerName", layerName()).add("LayerArn", layerArn())
                .add("LatestMatchingVersion", latestMatchingVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerName":
            return Optional.ofNullable(clazz.cast(layerName()));
        case "LayerArn":
            return Optional.ofNullable(clazz.cast(layerArn()));
        case "LatestMatchingVersion":
            return Optional.ofNullable(clazz.cast(latestMatchingVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayersListItem, T> g) {
        return obj -> g.apply((LayersListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayersListItem> {
        /**
         * <p>
         * The name of the layer.
         * </p>
         * 
         * @param layerName
         *        The name of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerName(String layerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function layer.
         * </p>
         * 
         * @param layerArn
         *        The Amazon Resource Name (ARN) of the function layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerArn(String layerArn);

        /**
         * <p>
         * The newest version of the layer.
         * </p>
         * 
         * @param latestMatchingVersion
         *        The newest version of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestMatchingVersion(LayerVersionsListItem latestMatchingVersion);

        /**
         * <p>
         * The newest version of the layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayerVersionsListItem.Builder} avoiding
         * the need to create one manually via {@link LayerVersionsListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayerVersionsListItem.Builder#build()} is called immediately and
         * its result is passed to {@link #latestMatchingVersion(LayerVersionsListItem)}.
         * 
         * @param latestMatchingVersion
         *        a consumer that will call methods on {@link LayerVersionsListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestMatchingVersion(LayerVersionsListItem)
         */
        default Builder latestMatchingVersion(Consumer<LayerVersionsListItem.Builder> latestMatchingVersion) {
            return latestMatchingVersion(LayerVersionsListItem.builder().applyMutation(latestMatchingVersion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String layerName;

        private String layerArn;

        private LayerVersionsListItem latestMatchingVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LayersListItem model) {
            layerName(model.layerName);
            layerArn(model.layerArn);
            latestMatchingVersion(model.latestMatchingVersion);
        }

        public final String getLayerName() {
            return layerName;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final String getLayerArn() {
            return layerArn;
        }

        public final void setLayerArn(String layerArn) {
            this.layerArn = layerArn;
        }

        @Override
        public final Builder layerArn(String layerArn) {
            this.layerArn = layerArn;
            return this;
        }

        public final LayerVersionsListItem.Builder getLatestMatchingVersion() {
            return latestMatchingVersion != null ? latestMatchingVersion.toBuilder() : null;
        }

        public final void setLatestMatchingVersion(LayerVersionsListItem.BuilderImpl latestMatchingVersion) {
            this.latestMatchingVersion = latestMatchingVersion != null ? latestMatchingVersion.build() : null;
        }

        @Override
        public final Builder latestMatchingVersion(LayerVersionsListItem latestMatchingVersion) {
            this.latestMatchingVersion = latestMatchingVersion;
            return this;
        }

        @Override
        public LayersListItem build() {
            return new LayersListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
