/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionUrlConfig;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse;

public class ListFunctionUrlConfigsIterable
implements SdkIterable<ListFunctionUrlConfigsResponse> {
    private final LambdaClient client;
    private final ListFunctionUrlConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFunctionUrlConfigsIterable(LambdaClient client, ListFunctionUrlConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFunctionUrlConfigsResponseFetcher();
    }

    public Iterator<ListFunctionUrlConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FunctionUrlConfig> functionUrlConfigs() {
        Function<ListFunctionUrlConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionUrlConfigs() != null) {
                return response.functionUrlConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFunctionUrlConfigsResponseFetcher
    implements SyncPageFetcher<ListFunctionUrlConfigsResponse> {
        private ListFunctionUrlConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionUrlConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListFunctionUrlConfigsResponse nextPage(ListFunctionUrlConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionUrlConfigsIterable.this.client.listFunctionUrlConfigs(ListFunctionUrlConfigsIterable.this.firstRequest);
            }
            return ListFunctionUrlConfigsIterable.this.client.listFunctionUrlConfigs((ListFunctionUrlConfigsRequest)((Object)ListFunctionUrlConfigsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

