/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.Cors;
import software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFunctionUrlConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, CreateFunctionUrlConfigResponse> {
    private static final SdkField<String> FUNCTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionUrl").getter(CreateFunctionUrlConfigResponse.getter(CreateFunctionUrlConfigResponse::functionUrl)).setter(CreateFunctionUrlConfigResponse.setter(Builder::functionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionUrl").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(CreateFunctionUrlConfigResponse.getter(CreateFunctionUrlConfigResponse::functionArn)).setter(CreateFunctionUrlConfigResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(CreateFunctionUrlConfigResponse.getter(CreateFunctionUrlConfigResponse::authTypeAsString)).setter(CreateFunctionUrlConfigResponse.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<Cors> CORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cors").getter(CreateFunctionUrlConfigResponse.getter(CreateFunctionUrlConfigResponse::cors)).setter(CreateFunctionUrlConfigResponse.setter(Builder::cors)).constructor(Cors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cors").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(CreateFunctionUrlConfigResponse.getter(CreateFunctionUrlConfigResponse::creationTime)).setter(CreateFunctionUrlConfigResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_URL_FIELD, FUNCTION_ARN_FIELD, AUTH_TYPE_FIELD, CORS_FIELD, CREATION_TIME_FIELD));
    private final String functionUrl;
    private final String functionArn;
    private final String authType;
    private final Cors cors;
    private final String creationTime;

    private CreateFunctionUrlConfigResponse(BuilderImpl builder) {
        super(builder);
        this.functionUrl = builder.functionUrl;
        this.functionArn = builder.functionArn;
        this.authType = builder.authType;
        this.cors = builder.cors;
        this.creationTime = builder.creationTime;
    }

    public final String functionUrl() {
        return this.functionUrl;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final FunctionUrlAuthType authType() {
        return FunctionUrlAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final Cors cors() {
        return this.cors;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cors());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionUrlConfigResponse)) {
            return false;
        }
        CreateFunctionUrlConfigResponse other = (CreateFunctionUrlConfigResponse)((Object)obj);
        return Objects.equals(this.functionUrl(), other.functionUrl()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.cors(), other.cors()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFunctionUrlConfigResponse").add("FunctionUrl", (Object)this.functionUrl()).add("FunctionArn", (Object)this.functionArn()).add("AuthType", (Object)this.authTypeAsString()).add("Cors", (Object)this.cors()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionUrl": {
                return Optional.ofNullable(clazz.cast(this.functionUrl()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "Cors": {
                return Optional.ofNullable(clazz.cast(this.cors()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionUrlConfigResponse, T> g) {
        return obj -> g.apply((CreateFunctionUrlConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String functionUrl;
        private String functionArn;
        private String authType;
        private Cors cors;
        private String creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionUrlConfigResponse model) {
            super(model);
            this.functionUrl(model.functionUrl);
            this.functionArn(model.functionArn);
            this.authType(model.authType);
            this.cors(model.cors);
            this.creationTime(model.creationTime);
        }

        public final String getFunctionUrl() {
            return this.functionUrl;
        }

        public final void setFunctionUrl(String functionUrl) {
            this.functionUrl = functionUrl;
        }

        @Override
        public final Builder functionUrl(String functionUrl) {
            this.functionUrl = functionUrl;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(FunctionUrlAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Cors.Builder getCors() {
            return this.cors != null ? this.cors.toBuilder() : null;
        }

        public final void setCors(Cors.BuilderImpl cors) {
            this.cors = cors != null ? cors.build() : null;
        }

        @Override
        public final Builder cors(Cors cors) {
            this.cors = cors;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateFunctionUrlConfigResponse build() {
            return new CreateFunctionUrlConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFunctionUrlConfigResponse> {
        public Builder functionUrl(String var1);

        public Builder functionArn(String var1);

        public Builder authType(String var1);

        public Builder authType(FunctionUrlAuthType var1);

        public Builder cors(Cors var1);

        default public Builder cors(Consumer<Cors.Builder> cors) {
            return this.cors((Cors)((Cors.Builder)Cors.builder().applyMutation(cors)).build());
        }

        public Builder creationTime(String var1);
    }
}

