/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StateReasonCode {
    IDLE("Idle"),
    CREATING("Creating"),
    RESTORING("Restoring"),
    ENI_LIMIT_EXCEEDED("EniLimitExceeded"),
    INSUFFICIENT_ROLE_PERMISSIONS("InsufficientRolePermissions"),
    INVALID_CONFIGURATION("InvalidConfiguration"),
    INTERNAL_ERROR("InternalError"),
    SUBNET_OUT_OF_IP_ADDRESSES("SubnetOutOfIPAddresses"),
    INVALID_SUBNET("InvalidSubnet"),
    INVALID_SECURITY_GROUP("InvalidSecurityGroup"),
    IMAGE_DELETED("ImageDeleted"),
    IMAGE_ACCESS_DENIED("ImageAccessDenied"),
    INVALID_IMAGE("InvalidImage"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StateReasonCode> VALUE_MAP;
    private final String value;

    private StateReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateReasonCode> knownValues() {
        EnumSet<StateReasonCode> knownValues = EnumSet.allOf(StateReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StateReasonCode.class, StateReasonCode::toString);
    }
}

