/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionCode> {
    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ZipFile").getter(FunctionCode.getter(FunctionCode::zipFile)).setter(FunctionCode.setter(Builder::zipFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(FunctionCode.getter(FunctionCode::s3Bucket)).setter(FunctionCode.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Key").getter(FunctionCode.getter(FunctionCode::s3Key)).setter(FunctionCode.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()}).build();
    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ObjectVersion").getter(FunctionCode.getter(FunctionCode::s3ObjectVersion)).setter(FunctionCode.setter(Builder::s3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectVersion").build()}).build();
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(FunctionCode.getter(FunctionCode::imageUri)).setter(FunctionCode.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZIP_FILE_FIELD, S3_BUCKET_FIELD, S3_KEY_FIELD, S3_OBJECT_VERSION_FIELD, IMAGE_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes zipFile;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;
    private final String imageUri;

    private FunctionCode(BuilderImpl builder) {
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.imageUri = builder.imageUri;
    }

    public final SdkBytes zipFile() {
        return this.zipFile;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public final String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCode)) {
            return false;
        }
        FunctionCode other = (FunctionCode)obj;
        return Objects.equals(this.zipFile(), other.zipFile()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3ObjectVersion(), other.s3ObjectVersion()) && Objects.equals(this.imageUri(), other.imageUri());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionCode").add("ZipFile", (Object)(this.zipFile() == null ? null : "*** Sensitive Data Redacted ***")).add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3ObjectVersion", (Object)this.s3ObjectVersion()).add("ImageUri", (Object)this.imageUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ZipFile": {
                return Optional.ofNullable(clazz.cast(this.zipFile()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "S3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectVersion()));
            }
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionCode, T> g) {
        return obj -> g.apply((FunctionCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes zipFile;
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;
        private String imageUri;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCode model) {
            this.zipFile(model.zipFile);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3ObjectVersion(model.s3ObjectVersion);
            this.imageUri(model.imageUri);
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile == null ? null : this.zipFile.asByteBuffer();
        }

        @Override
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = StandardMemberCopier.copy((SdkBytes)zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)zipFile));
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        public FunctionCode build() {
            return new FunctionCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionCode> {
        public Builder zipFile(SdkBytes var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);

        public Builder imageUri(String var1);
    }
}

