/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.FileSystemConfig;
import software.amazon.awssdk.services.lambda.model.FileSystemConfigListCopier;
import software.amazon.awssdk.services.lambda.model.ImageConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LayerListCopier;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFunctionConfigurationRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::functionName)).setter(UpdateFunctionConfigurationRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::role)).setter(UpdateFunctionConfigurationRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::handler)).setter(UpdateFunctionConfigurationRequest.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::description)).setter(UpdateFunctionConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::timeout)).setter(UpdateFunctionConfigurationRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySize").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::memorySize)).setter(UpdateFunctionConfigurationRequest.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::vpcConfig)).setter(UpdateFunctionConfigurationRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::environment)).setter(UpdateFunctionConfigurationRequest.setter(Builder::environment)).constructor(Environment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Runtime").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::runtimeAsString)).setter(UpdateFunctionConfigurationRequest.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::deadLetterConfig)).setter(UpdateFunctionConfigurationRequest.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyArn").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::kmsKeyArn)).setter(UpdateFunctionConfigurationRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final SdkField<TracingConfig> TRACING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TracingConfig").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::tracingConfig)).setter(UpdateFunctionConfigurationRequest.setter(Builder::tracingConfig)).constructor(TracingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::revisionId)).setter(UpdateFunctionConfigurationRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<List<String>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layers").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::layers)).setter(UpdateFunctionConfigurationRequest.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemConfigs").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::fileSystemConfigs)).setter(UpdateFunctionConfigurationRequest.setter(Builder::fileSystemConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfig").getter(UpdateFunctionConfigurationRequest.getter(UpdateFunctionConfigurationRequest::imageConfig)).setter(UpdateFunctionConfigurationRequest.setter(Builder::imageConfig)).constructor(ImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, ROLE_FIELD, HANDLER_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD, VPC_CONFIG_FIELD, ENVIRONMENT_FIELD, RUNTIME_FIELD, DEAD_LETTER_CONFIG_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, REVISION_ID_FIELD, LAYERS_FIELD, FILE_SYSTEM_CONFIGS_FIELD, IMAGE_CONFIG_FIELD));
    private final String functionName;
    private final String role;
    private final String handler;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final VpcConfig vpcConfig;
    private final Environment environment;
    private final String runtime;
    private final DeadLetterConfig deadLetterConfig;
    private final String kmsKeyArn;
    private final TracingConfig tracingConfig;
    private final String revisionId;
    private final List<String> layers;
    private final List<FileSystemConfig> fileSystemConfigs;
    private final ImageConfig imageConfig;

    private UpdateFunctionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.role = builder.role;
        this.handler = builder.handler;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.vpcConfig = builder.vpcConfig;
        this.environment = builder.environment;
        this.runtime = builder.runtime;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.revisionId = builder.revisionId;
        this.layers = builder.layers;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.imageConfig = builder.imageConfig;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String role() {
        return this.role;
    }

    public final String handler() {
        return this.handler;
    }

    public final String description() {
        return this.description;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer memorySize() {
        return this.memorySize;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Environment environment() {
        return this.environment;
    }

    public final Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final TracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<String> layers() {
        return this.layers;
    }

    public final boolean hasFileSystemConfigs() {
        return this.fileSystemConfigs != null && !(this.fileSystemConfigs instanceof SdkAutoConstructList);
    }

    public final List<FileSystemConfig> fileSystemConfigs() {
        return this.fileSystemConfigs;
    }

    public final ImageConfig imageConfig() {
        return this.imageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionConfigurationRequest)) {
            return false;
        }
        UpdateFunctionConfigurationRequest other = (UpdateFunctionConfigurationRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && Objects.equals(this.revisionId(), other.revisionId()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && this.hasFileSystemConfigs() == other.hasFileSystemConfigs() && Objects.equals(this.fileSystemConfigs(), other.fileSystemConfigs()) && Objects.equals(this.imageConfig(), other.imageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFunctionConfigurationRequest").add("FunctionName", (Object)this.functionName()).add("Role", (Object)this.role()).add("Handler", (Object)this.handler()).add("Description", (Object)this.description()).add("Timeout", (Object)this.timeout()).add("MemorySize", (Object)this.memorySize()).add("VpcConfig", (Object)this.vpcConfig()).add("Environment", (Object)this.environment()).add("Runtime", (Object)this.runtimeAsString()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("KMSKeyArn", (Object)this.kmsKeyArn()).add("TracingConfig", (Object)this.tracingConfig()).add("RevisionId", (Object)this.revisionId()).add("Layers", this.hasLayers() ? this.layers() : null).add("FileSystemConfigs", this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null).add("ImageConfig", (Object)this.imageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.ofNullable(clazz.cast(this.tracingConfig()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "FileSystemConfigs": {
                return Optional.ofNullable(clazz.cast(this.fileSystemConfigs()));
            }
            case "ImageConfig": {
                return Optional.ofNullable(clazz.cast(this.imageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateFunctionConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String role;
        private String handler;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private VpcConfig vpcConfig;
        private Environment environment;
        private String runtime;
        private DeadLetterConfig deadLetterConfig;
        private String kmsKeyArn;
        private TracingConfig tracingConfig;
        private String revisionId;
        private List<String> layers = DefaultSdkAutoConstructList.getInstance();
        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();
        private ImageConfig imageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionConfigurationRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.role(model.role);
            this.handler(model.handler);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.vpcConfig(model.vpcConfig);
            this.environment(model.environment);
            this.runtime(model.runtime);
            this.deadLetterConfig(model.deadLetterConfig);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
            this.revisionId(model.revisionId);
            this.layers(model.layers);
            this.fileSystemConfigs(model.fileSystemConfigs);
            this.imageConfig(model.imageConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Environment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Collection<String> getLayers() {
            if (this.layers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.layers;
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        public final Collection<FileSystemConfig.Builder> getFileSystemConfigs() {
            if (this.fileSystemConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileSystemConfigs != null ? (Collection)this.fileSystemConfigs.stream().map(FileSystemConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig ... fileSystemConfigs) {
            this.fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... fileSystemConfigs) {
            this.fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> (FileSystemConfig)((FileSystemConfig.Builder)FileSystemConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        public final ImageConfig.Builder getImageConfig() {
            return this.imageConfig != null ? this.imageConfig.toBuilder() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionConfigurationRequest build() {
            return new UpdateFunctionConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
        public Builder functionName(String var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder environment(Environment var1);

        default public Builder environment(Consumer<Environment.Builder> environment) {
            return this.environment((Environment)((Environment.Builder)Environment.builder().applyMutation(environment)).build());
        }

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfig var1);

        default public Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfig)((TracingConfig.Builder)TracingConfig.builder().applyMutation(tracingConfig)).build());
        }

        public Builder revisionId(String var1);

        public Builder layers(Collection<String> var1);

        public Builder layers(String ... var1);

        public Builder fileSystemConfigs(Collection<FileSystemConfig> var1);

        public Builder fileSystemConfigs(FileSystemConfig ... var1);

        public Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... var1);

        public Builder imageConfig(ImageConfig var1);

        default public Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return this.imageConfig((ImageConfig)((ImageConfig.Builder)ImageConfig.builder().applyMutation(imageConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

