/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.EndPointType;
import software.amazon.awssdk.services.lambda.model.EndpointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfManagedEventSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfManagedEventSource> {
    private static final SdkField<Map<String, List<String>>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Endpoints").getter(SelfManagedEventSource.getter(SelfManagedEventSource::endpointsAsStrings)).setter(SelfManagedEventSource.setter(Builder::endpointsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> endpoints;

    private SelfManagedEventSource(BuilderImpl builder) {
        this.endpoints = builder.endpoints;
    }

    public Map<EndPointType, List<String>> endpoints() {
        return EndpointsCopier.copyStringToEnum(this.endpoints);
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> endpointsAsStrings() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpointsAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedEventSource)) {
            return false;
        }
        SelfManagedEventSource other = (SelfManagedEventSource)obj;
        return this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpointsAsStrings(), other.endpointsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"SelfManagedEventSource").add("Endpoints", this.hasEndpoints() ? this.endpointsAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpointsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedEventSource, T> g) {
        return obj -> g.apply((SelfManagedEventSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> endpoints = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedEventSource model) {
            this.endpointsWithStrings(model.endpoints);
        }

        public final Map<String, ? extends Collection<String>> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endpoints;
        }

        @Override
        public final Builder endpointsWithStrings(Map<String, ? extends Collection<String>> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        public final Builder endpoints(Map<EndPointType, ? extends Collection<String>> endpoints) {
            this.endpoints = EndpointsCopier.copyEnumToString(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, ? extends Collection<String>> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
        }

        public SelfManagedEventSource build() {
            return new SelfManagedEventSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfManagedEventSource> {
        public Builder endpointsWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder endpoints(Map<EndPointType, ? extends Collection<String>> var1);
    }
}

