/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.AllowedPublishers;
import software.amazon.awssdk.services.lambda.model.CodeSigningPolicies;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCodeSigningConfigRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, UpdateCodeSigningConfigRequest> {
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSigningConfigArn").getter(UpdateCodeSigningConfigRequest.getter(UpdateCodeSigningConfigRequest::codeSigningConfigArn)).setter(UpdateCodeSigningConfigRequest.setter(Builder::codeSigningConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CodeSigningConfigArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateCodeSigningConfigRequest.getter(UpdateCodeSigningConfigRequest::description)).setter(UpdateCodeSigningConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AllowedPublishers> ALLOWED_PUBLISHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllowedPublishers").getter(UpdateCodeSigningConfigRequest.getter(UpdateCodeSigningConfigRequest::allowedPublishers)).setter(UpdateCodeSigningConfigRequest.setter(Builder::allowedPublishers)).constructor(AllowedPublishers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPublishers").build()}).build();
    private static final SdkField<CodeSigningPolicies> CODE_SIGNING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeSigningPolicies").getter(UpdateCodeSigningConfigRequest.getter(UpdateCodeSigningConfigRequest::codeSigningPolicies)).setter(UpdateCodeSigningConfigRequest.setter(Builder::codeSigningPolicies)).constructor(CodeSigningPolicies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningPolicies").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_ARN_FIELD, DESCRIPTION_FIELD, ALLOWED_PUBLISHERS_FIELD, CODE_SIGNING_POLICIES_FIELD));
    private final String codeSigningConfigArn;
    private final String description;
    private final AllowedPublishers allowedPublishers;
    private final CodeSigningPolicies codeSigningPolicies;

    private UpdateCodeSigningConfigRequest(BuilderImpl builder) {
        super(builder);
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.description = builder.description;
        this.allowedPublishers = builder.allowedPublishers;
        this.codeSigningPolicies = builder.codeSigningPolicies;
    }

    public String codeSigningConfigArn() {
        return this.codeSigningConfigArn;
    }

    public String description() {
        return this.description;
    }

    public AllowedPublishers allowedPublishers() {
        return this.allowedPublishers;
    }

    public CodeSigningPolicies codeSigningPolicies() {
        return this.codeSigningPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPublishers());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningPolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCodeSigningConfigRequest)) {
            return false;
        }
        UpdateCodeSigningConfigRequest other = (UpdateCodeSigningConfigRequest)((Object)obj);
        return Objects.equals(this.codeSigningConfigArn(), other.codeSigningConfigArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.allowedPublishers(), other.allowedPublishers()) && Objects.equals(this.codeSigningPolicies(), other.codeSigningPolicies());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCodeSigningConfigRequest").add("CodeSigningConfigArn", (Object)this.codeSigningConfigArn()).add("Description", (Object)this.description()).add("AllowedPublishers", (Object)this.allowedPublishers()).add("CodeSigningPolicies", (Object)this.codeSigningPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeSigningConfigArn": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AllowedPublishers": {
                return Optional.ofNullable(clazz.cast(this.allowedPublishers()));
            }
            case "CodeSigningPolicies": {
                return Optional.ofNullable(clazz.cast(this.codeSigningPolicies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCodeSigningConfigRequest, T> g) {
        return obj -> g.apply((UpdateCodeSigningConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String codeSigningConfigArn;
        private String description;
        private AllowedPublishers allowedPublishers;
        private CodeSigningPolicies codeSigningPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCodeSigningConfigRequest model) {
            super(model);
            this.codeSigningConfigArn(model.codeSigningConfigArn);
            this.description(model.description);
            this.allowedPublishers(model.allowedPublishers);
            this.codeSigningPolicies(model.codeSigningPolicies);
        }

        public final String getCodeSigningConfigArn() {
            return this.codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final AllowedPublishers.Builder getAllowedPublishers() {
            return this.allowedPublishers != null ? this.allowedPublishers.toBuilder() : null;
        }

        @Override
        public final Builder allowedPublishers(AllowedPublishers allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        public final void setAllowedPublishers(AllowedPublishers.BuilderImpl allowedPublishers) {
            this.allowedPublishers = allowedPublishers != null ? allowedPublishers.build() : null;
        }

        public final CodeSigningPolicies.Builder getCodeSigningPolicies() {
            return this.codeSigningPolicies != null ? this.codeSigningPolicies.toBuilder() : null;
        }

        @Override
        public final Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        public final void setCodeSigningPolicies(CodeSigningPolicies.BuilderImpl codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies != null ? codeSigningPolicies.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCodeSigningConfigRequest build() {
            return new UpdateCodeSigningConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCodeSigningConfigRequest> {
        public Builder codeSigningConfigArn(String var1);

        public Builder description(String var1);

        public Builder allowedPublishers(AllowedPublishers var1);

        default public Builder allowedPublishers(Consumer<AllowedPublishers.Builder> allowedPublishers) {
            return this.allowedPublishers((AllowedPublishers)((AllowedPublishers.Builder)AllowedPublishers.builder().applyMutation(allowedPublishers)).build());
        }

        public Builder codeSigningPolicies(CodeSigningPolicies var1);

        default public Builder codeSigningPolicies(Consumer<CodeSigningPolicies.Builder> codeSigningPolicies) {
            return this.codeSigningPolicies((CodeSigningPolicies)((CodeSigningPolicies.Builder)CodeSigningPolicies.builder().applyMutation(codeSigningPolicies)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

