/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Runtime {
    NODEJS("nodejs"),
    NODEJS4_3("nodejs4.3"),
    NODEJS6_10("nodejs6.10"),
    NODEJS8_10("nodejs8.10"),
    NODEJS10_X("nodejs10.x"),
    NODEJS12_X("nodejs12.x"),
    JAVA8("java8"),
    JAVA11("java11"),
    PYTHON2_7("python2.7"),
    PYTHON3_6("python3.6"),
    PYTHON3_7("python3.7"),
    PYTHON3_8("python3.8"),
    DOTNETCORE1_0("dotnetcore1.0"),
    DOTNETCORE2_0("dotnetcore2.0"),
    DOTNETCORE2_1("dotnetcore2.1"),
    NODEJS4_3_EDGE("nodejs4.3-edge"),
    GO1_X("go1.x"),
    RUBY2_5("ruby2.5"),
    PROVIDED("provided"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Runtime(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Runtime fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Runtime.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Runtime> knownValues() {
        return Stream.of(Runtime.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

