/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventSourceMappingResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetEventSourceMappingResponse> {
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::uuid)).setter(GetEventSourceMappingResponse.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::batchSize)).setter(GetEventSourceMappingResponse.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::eventSourceArn)).setter(GetEventSourceMappingResponse.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::functionArn)).setter(GetEventSourceMappingResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::lastModified)).setter(GetEventSourceMappingResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::lastProcessingResult)).setter(GetEventSourceMappingResponse.setter(Builder::lastProcessingResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::state)).setter(GetEventSourceMappingResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::stateTransitionReason)).setter(GetEventSourceMappingResponse.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD, BATCH_SIZE_FIELD, EVENT_SOURCE_ARN_FIELD, FUNCTION_ARN_FIELD, LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD));
    private final String uuid;
    private final Integer batchSize;
    private final String eventSourceArn;
    private final String functionArn;
    private final Instant lastModified;
    private final String lastProcessingResult;
    private final String state;
    private final String stateTransitionReason;

    private GetEventSourceMappingResponse(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.batchSize = builder.batchSize;
        this.eventSourceArn = builder.eventSourceArn;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
    }

    public String uuid() {
        return this.uuid;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public String eventSourceArn() {
        return this.eventSourceArn;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String lastProcessingResult() {
        return this.lastProcessingResult;
    }

    public String state() {
        return this.state;
    }

    public String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventSourceMappingResponse)) {
            return false;
        }
        GetEventSourceMappingResponse other = (GetEventSourceMappingResponse)((Object)obj);
        return Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason());
    }

    public String toString() {
        return ToString.builder((String)"GetEventSourceMappingResponse").add("UUID", (Object)this.uuid()).add("BatchSize", (Object)this.batchSize()).add("EventSourceArn", (Object)this.eventSourceArn()).add("FunctionArn", (Object)this.functionArn()).add("LastModified", (Object)this.lastModified()).add("LastProcessingResult", (Object)this.lastProcessingResult()).add("State", (Object)this.state()).add("StateTransitionReason", (Object)this.stateTransitionReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UUID": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LastProcessingResult": {
                return Optional.ofNullable(clazz.cast(this.lastProcessingResult()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventSourceMappingResponse, T> g) {
        return obj -> g.apply((GetEventSourceMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String uuid;
        private Integer batchSize;
        private String eventSourceArn;
        private String functionArn;
        private Instant lastModified;
        private String lastProcessingResult;
        private String state;
        private String stateTransitionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventSourceMappingResponse model) {
            super(model);
            this.uuid(model.uuid);
            this.batchSize(model.batchSize);
            this.eventSourceArn(model.eventSourceArn);
            this.functionArn(model.functionArn);
            this.lastModified(model.lastModified);
            this.lastProcessingResult(model.lastProcessingResult);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
        }

        public final String getUUID() {
            return this.uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUUID(String uuid) {
            this.uuid = uuid;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLastProcessingResult() {
            return this.lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public GetEventSourceMappingResponse build() {
            return new GetEventSourceMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventSourceMappingResponse> {
        public Builder uuid(String var1);

        public Builder batchSize(Integer var1);

        public Builder eventSourceArn(String var1);

        public Builder functionArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder lastProcessingResult(String var1);

        public Builder state(String var1);

        public Builder stateTransitionReason(String var1);
    }
}

