/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;

@SdkInternalApi
public class UntagResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ARN").build();
    private static final MarshallingInfo<List> TAGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("tagKeys").build();
    private static final UntagResourceRequestModelMarshaller INSTANCE = new UntagResourceRequestModelMarshaller();

    public static UntagResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UntagResourceRequest untagResourceRequest, ProtocolMarshaller protocolMarshaller) {
        if (untagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)untagResourceRequest.resource(), RESOURCE_BINDING);
            protocolMarshaller.marshall(untagResourceRequest.tagKeys(), TAGKEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

