/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAliasRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateAliasRequest> {
    private final String functionName;
    private final String name;
    private final String functionVersion;
    private final String description;

    private UpdateAliasRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
    }

    public String functionName() {
        return this.functionName;
    }

    public String name() {
        return this.name;
    }

    public String functionVersion() {
        return this.functionVersion;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAliasRequest)) {
            return false;
        }
        UpdateAliasRequest other = (UpdateAliasRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.functionVersion(), other.functionVersion()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.functionVersion() != null) {
            sb.append("FunctionVersion: ").append(this.functionVersion()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "FunctionVersion": {
                return Optional.of(clazz.cast(this.functionVersion()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String name;
        private String functionVersion;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAliasRequest model) {
            this.functionName(model.functionName);
            this.name(model.name);
            this.functionVersion(model.functionVersion);
            this.description(model.description);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public UpdateAliasRequest build() {
            return new UpdateAliasRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAliasRequest> {
        public Builder functionName(String var1);

        public Builder name(String var1);

        public Builder functionVersion(String var1);

        public Builder description(String var1);
    }
}

