/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ThrottleReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TooManyRequestsException
extends LambdaException
implements ToCopyableBuilder<Builder, TooManyRequestsException> {
    private final String retryAfterSeconds;
    private final String type;
    private final String reason;

    private TooManyRequestsException(BuilderImpl builder) {
        super(builder.message);
        this.retryAfterSeconds = builder.retryAfterSeconds;
        this.type = builder.type;
        this.reason = builder.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String retryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public String type() {
        return this.type;
    }

    public ThrottleReason reason() {
        return ThrottleReason.fromValue(this.reason);
    }

    public String reasonString() {
        return this.reason;
    }

    static final class BuilderImpl
    implements Builder {
        private String retryAfterSeconds;
        private String type;
        private String reason;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(TooManyRequestsException model) {
            this.retryAfterSeconds(model.retryAfterSeconds);
            this.type(model.type);
            this.reason(model.reason);
            this.message = model.getMessage();
        }

        public final String getRetryAfterSeconds() {
            return this.retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @JsonProperty(value="Retry-After")
        public final void setRetryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="Type")
        public final void setType(String type) {
            this.type = type;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ThrottleReason reason) {
            this.reason(reason.toString());
            return this;
        }

        @JsonProperty(value="Reason")
        public final void setReason(String reason) {
            this.reason = reason;
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public TooManyRequestsException build() {
            return new TooManyRequestsException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TooManyRequestsException> {
        public Builder retryAfterSeconds(String var1);

        public Builder type(String var1);

        public Builder reason(String var1);

        public Builder reason(ThrottleReason var1);

        public Builder message(String var1);
    }
}

