/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.AccountLimitMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountLimit
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountLimit> {
    private final Long totalCodeSize;
    private final Long codeSizeUnzipped;
    private final Long codeSizeZipped;
    private final Integer concurrentExecutions;

    private AccountLimit(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.codeSizeUnzipped = builder.codeSizeUnzipped;
        this.codeSizeZipped = builder.codeSizeZipped;
        this.concurrentExecutions = builder.concurrentExecutions;
    }

    public Long totalCodeSize() {
        return this.totalCodeSize;
    }

    public Long codeSizeUnzipped() {
        return this.codeSizeUnzipped;
    }

    public Long codeSizeZipped() {
        return this.codeSizeZipped;
    }

    public Integer concurrentExecutions() {
        return this.concurrentExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.totalCodeSize() == null ? 0 : this.totalCodeSize().hashCode());
        hashCode = 31 * hashCode + (this.codeSizeUnzipped() == null ? 0 : this.codeSizeUnzipped().hashCode());
        hashCode = 31 * hashCode + (this.codeSizeZipped() == null ? 0 : this.codeSizeZipped().hashCode());
        hashCode = 31 * hashCode + (this.concurrentExecutions() == null ? 0 : this.concurrentExecutions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLimit)) {
            return false;
        }
        AccountLimit other = (AccountLimit)obj;
        if (other.totalCodeSize() == null ^ this.totalCodeSize() == null) {
            return false;
        }
        if (other.totalCodeSize() != null && !other.totalCodeSize().equals(this.totalCodeSize())) {
            return false;
        }
        if (other.codeSizeUnzipped() == null ^ this.codeSizeUnzipped() == null) {
            return false;
        }
        if (other.codeSizeUnzipped() != null && !other.codeSizeUnzipped().equals(this.codeSizeUnzipped())) {
            return false;
        }
        if (other.codeSizeZipped() == null ^ this.codeSizeZipped() == null) {
            return false;
        }
        if (other.codeSizeZipped() != null && !other.codeSizeZipped().equals(this.codeSizeZipped())) {
            return false;
        }
        if (other.concurrentExecutions() == null ^ this.concurrentExecutions() == null) {
            return false;
        }
        return other.concurrentExecutions() == null || other.concurrentExecutions().equals(this.concurrentExecutions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.totalCodeSize() != null) {
            sb.append("TotalCodeSize: ").append(this.totalCodeSize()).append(",");
        }
        if (this.codeSizeUnzipped() != null) {
            sb.append("CodeSizeUnzipped: ").append(this.codeSizeUnzipped()).append(",");
        }
        if (this.codeSizeZipped() != null) {
            sb.append("CodeSizeZipped: ").append(this.codeSizeZipped()).append(",");
        }
        if (this.concurrentExecutions() != null) {
            sb.append("ConcurrentExecutions: ").append(this.concurrentExecutions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountLimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long totalCodeSize;
        private Long codeSizeUnzipped;
        private Long codeSizeZipped;
        private Integer concurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLimit model) {
            this.setTotalCodeSize(model.totalCodeSize);
            this.setCodeSizeUnzipped(model.codeSizeUnzipped);
            this.setCodeSizeZipped(model.codeSizeZipped);
            this.setConcurrentExecutions(model.concurrentExecutions);
        }

        public final Long getTotalCodeSize() {
            return this.totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        public final Long getCodeSizeUnzipped() {
            return this.codeSizeUnzipped;
        }

        @Override
        public final Builder codeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
            return this;
        }

        public final void setCodeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
        }

        public final Long getCodeSizeZipped() {
            return this.codeSizeZipped;
        }

        @Override
        public final Builder codeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
            return this;
        }

        public final void setCodeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
        }

        public final Integer getConcurrentExecutions() {
            return this.concurrentExecutions;
        }

        @Override
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        public AccountLimit build() {
            return new AccountLimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountLimit> {
        public Builder totalCodeSize(Long var1);

        public Builder codeSizeUnzipped(Long var1);

        public Builder codeSizeZipped(Long var1);

        public Builder concurrentExecutions(Integer var1);
    }
}

