/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteFunctionRequestModelMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Qualifier").isBinary(false).build();
    private static final DeleteFunctionRequestModelMarshaller INSTANCE = new DeleteFunctionRequestModelMarshaller();

    private DeleteFunctionRequestModelMarshaller() {
    }

    public static DeleteFunctionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteFunctionRequest deleteFunctionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteFunctionRequest), (String)"deleteFunctionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteFunctionRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)deleteFunctionRequest.qualifier(), QUALIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

