/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.AccountUsage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AccountUsageMarshaller {
    private static final MarshallingInfo<Long> TOTALCODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCodeSize").isBinary(false).build();
    private static final MarshallingInfo<Long> FUNCTIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionCount").isBinary(false).build();
    private static final AccountUsageMarshaller INSTANCE = new AccountUsageMarshaller();

    private AccountUsageMarshaller() {
    }

    public static AccountUsageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccountUsage accountUsage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)accountUsage, (String)"accountUsage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)accountUsage.totalCodeSize(), TOTALCODESIZE_BINDING);
            protocolMarshaller.marshall((Object)accountUsage.functionCount(), FUNCTIONCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

