/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.FunctionCodeLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionCodeLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionCodeLocation> {
    private final String repositoryType;
    private final String location;

    private FunctionCodeLocation(BuilderImpl builder) {
        this.repositoryType = builder.repositoryType;
        this.location = builder.location;
    }

    public String repositoryType() {
        return this.repositoryType;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryType());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCodeLocation)) {
            return false;
        }
        FunctionCodeLocation other = (FunctionCodeLocation)obj;
        return Objects.equals(this.repositoryType(), other.repositoryType()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"FunctionCodeLocation").add("RepositoryType", (Object)this.repositoryType()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryType": {
                return Optional.ofNullable(clazz.cast(this.repositoryType()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionCodeLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryType;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCodeLocation model) {
            this.repositoryType(model.repositoryType);
            this.location(model.location);
        }

        public final String getRepositoryType() {
            return this.repositoryType;
        }

        @Override
        public final Builder repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public final void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public FunctionCodeLocation build() {
            return new FunctionCodeLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionCodeLocation> {
        public Builder repositoryType(String var1);

        public Builder location(String var1);
    }
}

