/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.AdditionalVersionWeightsCopier;
import software.amazon.awssdk.services.lambda.transform.AliasRoutingConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasRoutingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, AliasRoutingConfiguration> {
    private final Map<String, Double> additionalVersionWeights;

    private AliasRoutingConfiguration(BuilderImpl builder) {
        this.additionalVersionWeights = builder.additionalVersionWeights;
    }

    public Map<String, Double> additionalVersionWeights() {
        return this.additionalVersionWeights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalVersionWeights());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasRoutingConfiguration)) {
            return false;
        }
        AliasRoutingConfiguration other = (AliasRoutingConfiguration)obj;
        return Objects.equals(this.additionalVersionWeights(), other.additionalVersionWeights());
    }

    public String toString() {
        return ToString.builder((String)"AliasRoutingConfiguration").add("AdditionalVersionWeights", this.additionalVersionWeights()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalVersionWeights": {
                return Optional.ofNullable(clazz.cast(this.additionalVersionWeights()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AliasRoutingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Double> additionalVersionWeights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AliasRoutingConfiguration model) {
            this.additionalVersionWeights(model.additionalVersionWeights);
        }

        public final Map<String, Double> getAdditionalVersionWeights() {
            return this.additionalVersionWeights;
        }

        @Override
        public final Builder additionalVersionWeights(Map<String, Double> additionalVersionWeights) {
            this.additionalVersionWeights = AdditionalVersionWeightsCopier.copy(additionalVersionWeights);
            return this;
        }

        public final void setAdditionalVersionWeights(Map<String, Double> additionalVersionWeights) {
            this.additionalVersionWeights = AdditionalVersionWeightsCopier.copy(additionalVersionWeights);
        }

        public AliasRoutingConfiguration build() {
            return new AliasRoutingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AliasRoutingConfiguration> {
        public Builder additionalVersionWeights(Map<String, Double> var1);
    }
}

