/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.EnvironmentErrorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentError
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentError> {
    private final String errorCode;
    private final String message;

    private EnvironmentError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentError)) {
            return false;
        }
        EnvironmentError other = (EnvironmentError)obj;
        return Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentError").add("ErrorCode", (Object)this.errorCode()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentError model) {
            this.errorCode(model.errorCode);
            this.message(model.message);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public EnvironmentError build() {
            return new EnvironmentError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentError> {
        public Builder errorCode(String var1);

        public Builder message(String var1);
    }
}

