/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lambda.model.FunctionCode;

public class FunctionCodeUnmarshaller
implements Unmarshaller<FunctionCode, JsonUnmarshallerContext> {
    private static final FunctionCodeUnmarshaller INSTANCE = new FunctionCodeUnmarshaller();

    public FunctionCode unmarshall(JsonUnmarshallerContext context) throws Exception {
        FunctionCode.Builder functionCodeBuilder = FunctionCode.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ZipFile", targetDepth)) {
                    context.nextToken();
                    functionCodeBuilder.zipFile((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Bucket", targetDepth)) {
                    context.nextToken();
                    functionCodeBuilder.s3Bucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Key", targetDepth)) {
                    context.nextToken();
                    functionCodeBuilder.s3Key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3ObjectVersion", targetDepth)) {
                    context.nextToken();
                    functionCodeBuilder.s3ObjectVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FunctionCode)functionCodeBuilder.build();
    }

    public static FunctionCodeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

