/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.FunctionCode;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FunctionCodeMarshaller {
    private static final MarshallingInfo<ByteBuffer> ZIPFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipFile").isBinary(false).build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").isBinary(false).build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Key").isBinary(false).build();
    private static final MarshallingInfo<String> S3OBJECTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ObjectVersion").isBinary(false).build();
    private static final FunctionCodeMarshaller INSTANCE = new FunctionCodeMarshaller();

    private FunctionCodeMarshaller() {
    }

    public static FunctionCodeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionCode functionCode, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)functionCode, (String)"functionCode");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)functionCode.zipFile(), ZIPFILE_BINDING);
            protocolMarshaller.marshall((Object)functionCode.s3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)functionCode.s3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall((Object)functionCode.s3ObjectVersion(), S3OBJECTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

