/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.Concurrency;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConcurrencyMarshaller {
    private static final MarshallingInfo<Integer> RESERVEDCONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedConcurrentExecutions").isBinary(false).build();
    private static final ConcurrencyMarshaller INSTANCE = new ConcurrencyMarshaller();

    private ConcurrencyMarshaller() {
    }

    public static ConcurrencyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Concurrency concurrency, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)concurrency, (String)"concurrency");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)concurrency.reservedConcurrentExecutions(), RESERVEDCONCURRENTEXECUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

