/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.lambda.transform.EnvironmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Environment
implements StructuredPojo,
ToCopyableBuilder<Builder, Environment> {
    private final Map<String, String> variables;

    private Environment(BuilderImpl builder) {
        this.variables = builder.variables;
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return Objects.equals(this.variables(), other.variables());
    }

    public String toString() {
        return ToString.builder((String)"Environment").add("Variables", this.variables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Variables": {
                return Optional.of(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> variables;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.variables(model.variables);
        }

        public final Map<String, String> getVariables() {
            return this.variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
        }

        public Environment build() {
            return new Environment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Environment> {
        public Builder variables(Map<String, String> var1);
    }
}

