/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateRandomResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GenerateRandomResponse> {
    private static final SdkField<SdkBytes> PLAINTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(GenerateRandomResponse.getter(GenerateRandomResponse::plaintext)).setter(GenerateRandomResponse.setter(Builder::plaintext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plaintext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAINTEXT_FIELD));
    private final SdkBytes plaintext;

    private GenerateRandomResponse(BuilderImpl builder) {
        super(builder);
        this.plaintext = builder.plaintext;
    }

    public SdkBytes plaintext() {
        return this.plaintext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomResponse)) {
            return false;
        }
        GenerateRandomResponse other = (GenerateRandomResponse)((Object)obj);
        return Objects.equals(this.plaintext(), other.plaintext());
    }

    public String toString() {
        return ToString.builder((String)"GenerateRandomResponse").add("Plaintext", (Object)this.plaintext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateRandomResponse, T> g) {
        return obj -> g.apply((GenerateRandomResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomResponse model) {
            super(model);
            this.plaintext(model.plaintext);
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = StandardMemberCopier.copy((SdkBytes)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        @Override
        public GenerateRandomResponse build() {
            return new GenerateRandomResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateRandomResponse> {
        public Builder plaintext(SdkBytes var1);
    }
}

