/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KeyAgreementAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.RecipientInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeriveSharedSecretRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, DeriveSharedSecretRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(DeriveSharedSecretRequest.getter(DeriveSharedSecretRequest::keyId)).setter(DeriveSharedSecretRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> KEY_AGREEMENT_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAgreementAlgorithm").getter(DeriveSharedSecretRequest.getter(DeriveSharedSecretRequest::keyAgreementAlgorithmAsString)).setter(DeriveSharedSecretRequest.setter(Builder::keyAgreementAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreementAlgorithm").build()}).build();
    private static final SdkField<SdkBytes> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("PublicKey").getter(DeriveSharedSecretRequest.getter(DeriveSharedSecretRequest::publicKey)).setter(DeriveSharedSecretRequest.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(DeriveSharedSecretRequest.getter(DeriveSharedSecretRequest::grantTokens)).setter(DeriveSharedSecretRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeriveSharedSecretRequest.getter(DeriveSharedSecretRequest::dryRun)).setter(DeriveSharedSecretRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<RecipientInfo> RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recipient").getter(DeriveSharedSecretRequest.getter(DeriveSharedSecretRequest::recipient)).setter(DeriveSharedSecretRequest.setter(Builder::recipient)).constructor(RecipientInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipient").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, KEY_AGREEMENT_ALGORITHM_FIELD, PUBLIC_KEY_FIELD, GRANT_TOKENS_FIELD, DRY_RUN_FIELD, RECIPIENT_FIELD));
    private final String keyId;
    private final String keyAgreementAlgorithm;
    private final SdkBytes publicKey;
    private final List<String> grantTokens;
    private final Boolean dryRun;
    private final RecipientInfo recipient;

    private DeriveSharedSecretRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.keyAgreementAlgorithm = builder.keyAgreementAlgorithm;
        this.publicKey = builder.publicKey;
        this.grantTokens = builder.grantTokens;
        this.dryRun = builder.dryRun;
        this.recipient = builder.recipient;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final KeyAgreementAlgorithmSpec keyAgreementAlgorithm() {
        return KeyAgreementAlgorithmSpec.fromValue(this.keyAgreementAlgorithm);
    }

    public final String keyAgreementAlgorithmAsString() {
        return this.keyAgreementAlgorithm;
    }

    public final SdkBytes publicKey() {
        return this.publicKey;
    }

    public final boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public final List<String> grantTokens() {
        return this.grantTokens;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final RecipientInfo recipient() {
        return this.recipient;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAgreementAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipient());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeriveSharedSecretRequest)) {
            return false;
        }
        DeriveSharedSecretRequest other = (DeriveSharedSecretRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyAgreementAlgorithmAsString(), other.keyAgreementAlgorithmAsString()) && Objects.equals(this.publicKey(), other.publicKey()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.recipient(), other.recipient());
    }

    public final String toString() {
        return ToString.builder((String)"DeriveSharedSecretRequest").add("KeyId", (Object)this.keyId()).add("KeyAgreementAlgorithm", (Object)this.keyAgreementAlgorithmAsString()).add("PublicKey", (Object)this.publicKey()).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("DryRun", (Object)this.dryRun()).add("Recipient", (Object)this.recipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyAgreementAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAgreementAlgorithmAsString()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Recipient": {
                return Optional.ofNullable(clazz.cast(this.recipient()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeriveSharedSecretRequest, T> g) {
        return obj -> g.apply((DeriveSharedSecretRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String keyAgreementAlgorithm;
        private SdkBytes publicKey;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private RecipientInfo recipient;

        private BuilderImpl() {
        }

        private BuilderImpl(DeriveSharedSecretRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.keyAgreementAlgorithm(model.keyAgreementAlgorithm);
            this.publicKey(model.publicKey);
            this.grantTokens(model.grantTokens);
            this.dryRun(model.dryRun);
            this.recipient(model.recipient);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyAgreementAlgorithm() {
            return this.keyAgreementAlgorithm;
        }

        public final void setKeyAgreementAlgorithm(String keyAgreementAlgorithm) {
            this.keyAgreementAlgorithm = keyAgreementAlgorithm;
        }

        @Override
        public final Builder keyAgreementAlgorithm(String keyAgreementAlgorithm) {
            this.keyAgreementAlgorithm = keyAgreementAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAgreementAlgorithm(KeyAgreementAlgorithmSpec keyAgreementAlgorithm) {
            this.keyAgreementAlgorithm(keyAgreementAlgorithm == null ? null : keyAgreementAlgorithm.toString());
            return this;
        }

        public final ByteBuffer getPublicKey() {
            return this.publicKey == null ? null : this.publicKey.asByteBuffer();
        }

        public final void setPublicKey(ByteBuffer publicKey) {
            this.publicKey(publicKey == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)publicKey));
        }

        @Override
        public final Builder publicKey(SdkBytes publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final RecipientInfo.Builder getRecipient() {
            return this.recipient != null ? this.recipient.toBuilder() : null;
        }

        public final void setRecipient(RecipientInfo.BuilderImpl recipient) {
            this.recipient = recipient != null ? recipient.build() : null;
        }

        @Override
        public final Builder recipient(RecipientInfo recipient) {
            this.recipient = recipient;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeriveSharedSecretRequest build() {
            return new DeriveSharedSecretRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeriveSharedSecretRequest> {
        public Builder keyId(String var1);

        public Builder keyAgreementAlgorithm(String var1);

        public Builder keyAgreementAlgorithm(KeyAgreementAlgorithmSpec var1);

        public Builder publicKey(SdkBytes var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder recipient(RecipientInfo var1);

        default public Builder recipient(Consumer<RecipientInfo.Builder> recipient) {
            return this.recipient((RecipientInfo)((RecipientInfo.Builder)RecipientInfo.builder().applyMutation(recipient)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

