/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.services.kms.model.Tag;
import software.amazon.awssdk.services.kms.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, CreateKeyRequest> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(CreateKeyRequest.getter(CreateKeyRequest::policy)).setter(CreateKeyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateKeyRequest.getter(CreateKeyRequest::description)).setter(CreateKeyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyUsage").getter(CreateKeyRequest.getter(CreateKeyRequest::keyUsageAsString)).setter(CreateKeyRequest.setter(Builder::keyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final SdkField<String> CUSTOMER_MASTER_KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerMasterKeySpec").getter(CreateKeyRequest.getter(CreateKeyRequest::customerMasterKeySpecAsString)).setter(CreateKeyRequest.setter(Builder::customerMasterKeySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMasterKeySpec").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(CreateKeyRequest.getter(CreateKeyRequest::originAsString)).setter(CreateKeyRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreId").getter(CreateKeyRequest.getter(CreateKeyRequest::customKeyStoreId)).setter(CreateKeyRequest.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BypassPolicyLockoutSafetyCheck").getter(CreateKeyRequest.getter(CreateKeyRequest::bypassPolicyLockoutSafetyCheck)).setter(CreateKeyRequest.setter(Builder::bypassPolicyLockoutSafetyCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassPolicyLockoutSafetyCheck").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateKeyRequest.getter(CreateKeyRequest::tags)).setter(CreateKeyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiRegion").getter(CreateKeyRequest.getter(CreateKeyRequest::multiRegion)).setter(CreateKeyRequest.setter(Builder::multiRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, DESCRIPTION_FIELD, KEY_USAGE_FIELD, CUSTOMER_MASTER_KEY_SPEC_FIELD, ORIGIN_FIELD, CUSTOM_KEY_STORE_ID_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD, TAGS_FIELD, MULTI_REGION_FIELD));
    private final String policy;
    private final String description;
    private final String keyUsage;
    private final String customerMasterKeySpec;
    private final String origin;
    private final String customKeyStoreId;
    private final Boolean bypassPolicyLockoutSafetyCheck;
    private final List<Tag> tags;
    private final Boolean multiRegion;

    private CreateKeyRequest(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.customerMasterKeySpec = builder.customerMasterKeySpec;
        this.origin = builder.origin;
        this.customKeyStoreId = builder.customKeyStoreId;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
        this.tags = builder.tags;
        this.multiRegion = builder.multiRegion;
    }

    public final String policy() {
        return this.policy;
    }

    public final String description() {
        return this.description;
    }

    public final KeyUsageType keyUsage() {
        return KeyUsageType.fromValue(this.keyUsage);
    }

    public final String keyUsageAsString() {
        return this.keyUsage;
    }

    public final CustomerMasterKeySpec customerMasterKeySpec() {
        return CustomerMasterKeySpec.fromValue(this.customerMasterKeySpec);
    }

    public final String customerMasterKeySpecAsString() {
        return this.customerMasterKeySpec;
    }

    public final OriginType origin() {
        return OriginType.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean multiRegion() {
        return this.multiRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerMasterKeySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassPolicyLockoutSafetyCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyRequest)) {
            return false;
        }
        CreateKeyRequest other = (CreateKeyRequest)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.keyUsageAsString(), other.keyUsageAsString()) && Objects.equals(this.customerMasterKeySpecAsString(), other.customerMasterKeySpecAsString()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.multiRegion(), other.multiRegion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyRequest").add("Policy", (Object)this.policy()).add("Description", (Object)this.description()).add("KeyUsage", (Object)this.keyUsageAsString()).add("CustomerMasterKeySpec", (Object)this.customerMasterKeySpecAsString()).add("Origin", (Object)this.originAsString()).add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("BypassPolicyLockoutSafetyCheck", (Object)this.bypassPolicyLockoutSafetyCheck()).add("Tags", this.hasTags() ? this.tags() : null).add("MultiRegion", (Object)this.multiRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsString()));
            }
            case "CustomerMasterKeySpec": {
                return Optional.ofNullable(clazz.cast(this.customerMasterKeySpecAsString()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "BypassPolicyLockoutSafetyCheck": {
                return Optional.ofNullable(clazz.cast(this.bypassPolicyLockoutSafetyCheck()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "MultiRegion": {
                return Optional.ofNullable(clazz.cast(this.multiRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyRequest, T> g) {
        return obj -> g.apply((CreateKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String policy;
        private String description;
        private String keyUsage;
        private String customerMasterKeySpec;
        private String origin;
        private String customKeyStoreId;
        private Boolean bypassPolicyLockoutSafetyCheck;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyRequest model) {
            super(model);
            this.policy(model.policy);
            this.description(model.description);
            this.keyUsage(model.keyUsage);
            this.customerMasterKeySpec(model.customerMasterKeySpec);
            this.origin(model.origin);
            this.customKeyStoreId(model.customKeyStoreId);
            this.bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
            this.tags(model.tags);
            this.multiRegion(model.multiRegion);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        @Override
        @Transient
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        @Transient
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage == null ? null : keyUsage.toString());
            return this;
        }

        public final String getCustomerMasterKeySpec() {
            return this.customerMasterKeySpec;
        }

        public final void setCustomerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = customerMasterKeySpec;
        }

        @Override
        @Transient
        public final Builder customerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = customerMasterKeySpec;
            return this;
        }

        @Override
        @Transient
        public final Builder customerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
            this.customerMasterKeySpec(customerMasterKeySpec == null ? null : customerMasterKeySpec.toString());
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        @Transient
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        @Transient
        public final Builder origin(OriginType origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        @Override
        @Transient
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        @Transient
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegion() {
            return this.multiRegion;
        }

        public final void setMultiRegion(Boolean multiRegion) {
            this.multiRegion = multiRegion;
        }

        @Override
        @Transient
        public final Builder multiRegion(Boolean multiRegion) {
            this.multiRegion = multiRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyRequest build() {
            return new CreateKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyRequest> {
        public Builder policy(String var1);

        public Builder description(String var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder customerMasterKeySpec(String var1);

        public Builder customerMasterKeySpec(CustomerMasterKeySpec var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder customKeyStoreId(String var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder multiRegion(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

