/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, EncryptResponse> {
    private static final SdkField<SdkBytes> CIPHERTEXT_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(EncryptResponse.getter(EncryptResponse::ciphertextBlob)).setter(EncryptResponse.setter(Builder::ciphertextBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextBlob").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EncryptResponse.getter(EncryptResponse::keyId)).setter(EncryptResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHERTEXT_BLOB_FIELD, KEY_ID_FIELD));
    private final SdkBytes ciphertextBlob;
    private final String keyId;

    private EncryptResponse(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.keyId = builder.keyId;
    }

    public SdkBytes ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptResponse)) {
            return false;
        }
        EncryptResponse other = (EncryptResponse)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        return ToString.builder((String)"EncryptResponse").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("KeyId", (Object)this.keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.ciphertextBlob()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptResponse, T> g) {
        return obj -> g.apply((EncryptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes ciphertextBlob;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptResponse model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.keyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob == null ? null : this.ciphertextBlob.asByteBuffer();
        }

        @Override
        public final Builder ciphertextBlob(SdkBytes ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((SdkBytes)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob(ciphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextBlob));
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public EncryptResponse build() {
            return new EncryptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EncryptResponse> {
        public Builder ciphertextBlob(SdkBytes var1);

        public Builder keyId(String var1);
    }
}

