/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType;
import software.amazon.awssdk.services.kms.model.ConnectionStateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomKeyStoresListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomKeyStoresListEntry> {
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::customKeyStoreId)).setter(CustomKeyStoresListEntry.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<String> CUSTOM_KEY_STORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::customKeyStoreName)).setter(CustomKeyStoresListEntry.setter(Builder::customKeyStoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreName").build()}).build();
    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::cloudHsmClusterId)).setter(CustomKeyStoresListEntry.setter(Builder::cloudHsmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::trustAnchorCertificate)).setter(CustomKeyStoresListEntry.setter(Builder::trustAnchorCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchorCertificate").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::connectionStateAsString)).setter(CustomKeyStoresListEntry.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()}).build();
    private static final SdkField<String> CONNECTION_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::connectionErrorCodeAsString)).setter(CustomKeyStoresListEntry.setter(Builder::connectionErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionErrorCode").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CustomKeyStoresListEntry.getter(CustomKeyStoresListEntry::creationDate)).setter(CustomKeyStoresListEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORE_ID_FIELD, CUSTOM_KEY_STORE_NAME_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD, TRUST_ANCHOR_CERTIFICATE_FIELD, CONNECTION_STATE_FIELD, CONNECTION_ERROR_CODE_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customKeyStoreId;
    private final String customKeyStoreName;
    private final String cloudHsmClusterId;
    private final String trustAnchorCertificate;
    private final String connectionState;
    private final String connectionErrorCode;
    private final Instant creationDate;

    private CustomKeyStoresListEntry(BuilderImpl builder) {
        this.customKeyStoreId = builder.customKeyStoreId;
        this.customKeyStoreName = builder.customKeyStoreName;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
        this.trustAnchorCertificate = builder.trustAnchorCertificate;
        this.connectionState = builder.connectionState;
        this.connectionErrorCode = builder.connectionErrorCode;
        this.creationDate = builder.creationDate;
    }

    public String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public String customKeyStoreName() {
        return this.customKeyStoreName;
    }

    public String cloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    public String trustAnchorCertificate() {
        return this.trustAnchorCertificate;
    }

    public ConnectionStateType connectionState() {
        return ConnectionStateType.fromValue(this.connectionState);
    }

    public String connectionStateAsString() {
        return this.connectionState;
    }

    public ConnectionErrorCodeType connectionErrorCode() {
        return ConnectionErrorCodeType.fromValue(this.connectionErrorCode);
    }

    public String connectionErrorCodeAsString() {
        return this.connectionErrorCode;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudHsmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionErrorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomKeyStoresListEntry)) {
            return false;
        }
        CustomKeyStoresListEntry other = (CustomKeyStoresListEntry)obj;
        return Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.customKeyStoreName(), other.customKeyStoreName()) && Objects.equals(this.cloudHsmClusterId(), other.cloudHsmClusterId()) && Objects.equals(this.trustAnchorCertificate(), other.trustAnchorCertificate()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.connectionErrorCodeAsString(), other.connectionErrorCodeAsString()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"CustomKeyStoresListEntry").add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("CustomKeyStoreName", (Object)this.customKeyStoreName()).add("CloudHsmClusterId", (Object)this.cloudHsmClusterId()).add("TrustAnchorCertificate", (Object)this.trustAnchorCertificate()).add("ConnectionState", (Object)this.connectionStateAsString()).add("ConnectionErrorCode", (Object)this.connectionErrorCodeAsString()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "CustomKeyStoreName": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreName()));
            }
            case "CloudHsmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudHsmClusterId()));
            }
            case "TrustAnchorCertificate": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorCertificate()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "ConnectionErrorCode": {
                return Optional.ofNullable(clazz.cast(this.connectionErrorCodeAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomKeyStoresListEntry, T> g) {
        return obj -> g.apply((CustomKeyStoresListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customKeyStoreId;
        private String customKeyStoreName;
        private String cloudHsmClusterId;
        private String trustAnchorCertificate;
        private String connectionState;
        private String connectionErrorCode;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomKeyStoresListEntry model) {
            this.customKeyStoreId(model.customKeyStoreId);
            this.customKeyStoreName(model.customKeyStoreName);
            this.cloudHsmClusterId(model.cloudHsmClusterId);
            this.trustAnchorCertificate(model.trustAnchorCertificate);
            this.connectionState(model.connectionState);
            this.connectionErrorCode(model.connectionErrorCode);
            this.creationDate(model.creationDate);
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        public final String getCustomKeyStoreName() {
            return this.customKeyStoreName;
        }

        @Override
        public final Builder customKeyStoreName(String customKeyStoreName) {
            this.customKeyStoreName = customKeyStoreName;
            return this;
        }

        public final void setCustomKeyStoreName(String customKeyStoreName) {
            this.customKeyStoreName = customKeyStoreName;
        }

        public final String getCloudHsmClusterId() {
            return this.cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        public final String getTrustAnchorCertificate() {
            return this.trustAnchorCertificate;
        }

        @Override
        public final Builder trustAnchorCertificate(String trustAnchorCertificate) {
            this.trustAnchorCertificate = trustAnchorCertificate;
            return this;
        }

        public final void setTrustAnchorCertificate(String trustAnchorCertificate) {
            this.trustAnchorCertificate = trustAnchorCertificate;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionStateType connectionState) {
            this.connectionState(connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final String getConnectionErrorCode() {
            return this.connectionErrorCode;
        }

        @Override
        public final Builder connectionErrorCode(String connectionErrorCode) {
            this.connectionErrorCode = connectionErrorCode;
            return this;
        }

        @Override
        public final Builder connectionErrorCode(ConnectionErrorCodeType connectionErrorCode) {
            this.connectionErrorCode(connectionErrorCode.toString());
            return this;
        }

        public final void setConnectionErrorCode(String connectionErrorCode) {
            this.connectionErrorCode = connectionErrorCode;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public CustomKeyStoresListEntry build() {
            return new CustomKeyStoresListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomKeyStoresListEntry> {
        public Builder customKeyStoreId(String var1);

        public Builder customKeyStoreName(String var1);

        public Builder cloudHsmClusterId(String var1);

        public Builder trustAnchorCertificate(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionStateType var1);

        public Builder connectionErrorCode(String var1);

        public Builder connectionErrorCode(ConnectionErrorCodeType var1);

        public Builder creationDate(Instant var1);
    }
}

