/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionType {
    INVALID_FORMAT("InvalidFormat"),
    TRIMMED_DATA_ACCESS("TrimmedDataAccess"),
    EXPIRED_ITERATOR("ExpiredIterator"),
    EXPIRED_NEXT_TOKEN("ExpiredNextToken"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionType> VALUE_MAP;
    private final String value;

    private ValidationExceptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionType> knownValues() {
        EnumSet<ValidationExceptionType> knownValues = EnumSet.allOf(ValidationExceptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionType.class, ValidationExceptionType::toString);
    }
}

