/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamResponse extends KeyspacesStreamsResponse implements
        ToCopyableBuilder<GetStreamResponse.Builder, GetStreamResponse> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamArn").getter(getter(GetStreamResponse::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()).build();

    private static final SdkField<String> STREAM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamLabel").getter(getter(GetStreamResponse::streamLabel)).setter(setter(Builder::streamLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamLabel").build()).build();

    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamStatus").getter(getter(GetStreamResponse::streamStatusAsString))
            .setter(setter(Builder::streamStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamStatus").build()).build();

    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamViewType").getter(getter(GetStreamResponse::streamViewTypeAsString))
            .setter(setter(Builder::streamViewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamViewType").build()).build();

    private static final SdkField<Instant> CREATION_REQUEST_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationRequestDateTime").getter(getter(GetStreamResponse::creationRequestDateTime))
            .setter(setter(Builder::creationRequestDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestDateTime").build())
            .build();

    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetStreamResponse::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(GetStreamResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<List<Shard>> SHARDS_FIELD = SdkField
            .<List<Shard>> builder(MarshallingType.LIST)
            .memberName("shards")
            .getter(getter(GetStreamResponse::shards))
            .setter(setter(Builder::shards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Shard> builder(MarshallingType.SDK_POJO)
                                            .constructor(Shard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetStreamResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            STREAM_LABEL_FIELD, STREAM_STATUS_FIELD, STREAM_VIEW_TYPE_FIELD, CREATION_REQUEST_DATE_TIME_FIELD,
            KEYSPACE_NAME_FIELD, TABLE_NAME_FIELD, SHARDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamArn;

    private final String streamLabel;

    private final String streamStatus;

    private final String streamViewType;

    private final Instant creationRequestDateTime;

    private final String keyspaceName;

    private final String tableName;

    private final List<Shard> shards;

    private final String nextToken;

    private GetStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.streamLabel = builder.streamLabel;
        this.streamStatus = builder.streamStatus;
        this.streamViewType = builder.streamViewType;
        this.creationRequestDateTime = builder.creationRequestDateTime;
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.shards = builder.shards;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the stream within Amazon Keyspaces. This ARN can be used
     * in other API operations to reference this specific stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the stream within Amazon Keyspaces. This ARN can
     *         be used in other API operations to reference this specific stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * A timestamp that serves as a unique identifier for this stream, used for debugging and monitoring purposes. The
     * stream label represents the point in time when the stream was created.
     * </p>
     * 
     * @return A timestamp that serves as a unique identifier for this stream, used for debugging and monitoring
     *         purposes. The stream label represents the point in time when the stream was created.
     */
    public final String streamLabel() {
        return streamLabel;
    }

    /**
     * <p>
     * The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
     * <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link StreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
     *         <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current status.
     * @see StreamStatus
     */
    public final StreamStatus streamStatus() {
        return StreamStatus.fromValue(streamStatus);
    }

    /**
     * <p>
     * The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
     * <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link StreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
     *         <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current status.
     * @see StreamStatus
     */
    public final String streamStatusAsString() {
        return streamStatus;
    }

    /**
     * <p>
     * The format of the data records in this stream. Currently, this can be one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the version of the row after the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the version of the row before the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamViewType}
     * will return {@link StreamViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamViewTypeAsString}.
     * </p>
     * 
     * @return The format of the data records in this stream. Currently, this can be one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
     *         default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the version of the row after the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the version of the row before the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public final StreamViewType streamViewType() {
        return StreamViewType.fromValue(streamViewType);
    }

    /**
     * <p>
     * The format of the data records in this stream. Currently, this can be one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the version of the row after the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the version of the row before the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamViewType}
     * will return {@link StreamViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamViewTypeAsString}.
     * </p>
     * 
     * @return The format of the data records in this stream. Currently, this can be one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
     *         default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the version of the row after the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the version of the row before the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public final String streamViewTypeAsString() {
        return streamViewType;
    }

    /**
     * <p>
     * The date and time when the request to create this stream was issued. The value is represented in ISO 8601 format.
     * </p>
     * 
     * @return The date and time when the request to create this stream was issued. The value is represented in ISO 8601
     *         format.
     */
    public final Instant creationRequestDateTime() {
        return creationRequestDateTime;
    }

    /**
     * <p>
     * The name of the keyspace containing the table associated with this stream. The keyspace name is part of the
     * table's hierarchical identifier in Amazon Keyspaces.
     * </p>
     * 
     * @return The name of the keyspace containing the table associated with this stream. The keyspace name is part of
     *         the table's hierarchical identifier in Amazon Keyspaces.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the table associated with this stream. The stream captures changes to rows in this Amazon Keyspaces
     * table.
     * </p>
     * 
     * @return The name of the table associated with this stream. The stream captures changes to rows in this Amazon
     *         Keyspaces table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShards() {
        return shards != null && !(shards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of shard objects associated with this stream. Each shard contains a subset of the stream's data records
     * and has its own unique identifier. The collection of shards represents the complete stream data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShards} method.
     * </p>
     * 
     * @return An array of shard objects associated with this stream. Each shard contains a subset of the stream's data
     *         records and has its own unique identifier. The collection of shards represents the complete stream data.
     */
    public final List<Shard> shards() {
        return shards;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent <code>GetStream</code> request. This token is returned if the
     * response contains more shards than can be returned in a single response.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent <code>GetStream</code> request. This token is
     *         returned if the response contains more shards than can be returned in a single response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationRequestDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasShards() ? shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamResponse)) {
            return false;
        }
        GetStreamResponse other = (GetStreamResponse) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(streamLabel(), other.streamLabel())
                && Objects.equals(streamStatusAsString(), other.streamStatusAsString())
                && Objects.equals(streamViewTypeAsString(), other.streamViewTypeAsString())
                && Objects.equals(creationRequestDateTime(), other.creationRequestDateTime())
                && Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(tableName(), other.tableName())
                && hasShards() == other.hasShards() && Objects.equals(shards(), other.shards())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamResponse").add("StreamArn", streamArn()).add("StreamLabel", streamLabel())
                .add("StreamStatus", streamStatusAsString()).add("StreamViewType", streamViewTypeAsString())
                .add("CreationRequestDateTime", creationRequestDateTime()).add("KeyspaceName", keyspaceName())
                .add("TableName", tableName()).add("Shards", hasShards() ? shards() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "streamLabel":
            return Optional.ofNullable(clazz.cast(streamLabel()));
        case "streamStatus":
            return Optional.ofNullable(clazz.cast(streamStatusAsString()));
        case "streamViewType":
            return Optional.ofNullable(clazz.cast(streamViewTypeAsString()));
        case "creationRequestDateTime":
            return Optional.ofNullable(clazz.cast(creationRequestDateTime()));
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "shards":
            return Optional.ofNullable(clazz.cast(shards()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("streamLabel", STREAM_LABEL_FIELD);
        map.put("streamStatus", STREAM_STATUS_FIELD);
        map.put("streamViewType", STREAM_VIEW_TYPE_FIELD);
        map.put("creationRequestDateTime", CREATION_REQUEST_DATE_TIME_FIELD);
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("shards", SHARDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamResponse, T> g) {
        return obj -> g.apply((GetStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesStreamsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the stream within Amazon Keyspaces. This ARN can be
         * used in other API operations to reference this specific stream.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the stream within Amazon Keyspaces. This ARN
         *        can be used in other API operations to reference this specific stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * A timestamp that serves as a unique identifier for this stream, used for debugging and monitoring purposes.
         * The stream label represents the point in time when the stream was created.
         * </p>
         * 
         * @param streamLabel
         *        A timestamp that serves as a unique identifier for this stream, used for debugging and monitoring
         *        purposes. The stream label represents the point in time when the stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamLabel(String streamLabel);

        /**
         * <p>
         * The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
         * <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current status.
         * </p>
         * 
         * @param streamStatus
         *        The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
         *        <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current
         *        status.
         * @see StreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
         * <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current status.
         * </p>
         * 
         * @param streamStatus
         *        The current status of the stream. Values can be <code>ENABLING</code>, <code>ENABLED</code>,
         *        <code>DISABLING</code>, or <code>DISABLED</code>. Operations on the stream depend on its current
         *        status.
         * @see StreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(StreamStatus streamStatus);

        /**
         * <p>
         * The format of the data records in this stream. Currently, this can be one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the version of the row after the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the version of the row before the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        The format of the data records in this stream. Currently, this can be one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
         *        default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the version of the row after the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the version of the row before the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(String streamViewType);

        /**
         * <p>
         * The format of the data records in this stream. Currently, this can be one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the version of the row after the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the version of the row before the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        The format of the data records in this stream. Currently, this can be one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
         *        default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the version of the row after the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the version of the row before the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(StreamViewType streamViewType);

        /**
         * <p>
         * The date and time when the request to create this stream was issued. The value is represented in ISO 8601
         * format.
         * </p>
         * 
         * @param creationRequestDateTime
         *        The date and time when the request to create this stream was issued. The value is represented in ISO
         *        8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationRequestDateTime(Instant creationRequestDateTime);

        /**
         * <p>
         * The name of the keyspace containing the table associated with this stream. The keyspace name is part of the
         * table's hierarchical identifier in Amazon Keyspaces.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace containing the table associated with this stream. The keyspace name is part
         *        of the table's hierarchical identifier in Amazon Keyspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the table associated with this stream. The stream captures changes to rows in this Amazon
         * Keyspaces table.
         * </p>
         * 
         * @param tableName
         *        The name of the table associated with this stream. The stream captures changes to rows in this Amazon
         *        Keyspaces table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * An array of shard objects associated with this stream. Each shard contains a subset of the stream's data
         * records and has its own unique identifier. The collection of shards represents the complete stream data.
         * </p>
         * 
         * @param shards
         *        An array of shard objects associated with this stream. Each shard contains a subset of the stream's
         *        data records and has its own unique identifier. The collection of shards represents the complete
         *        stream data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<Shard> shards);

        /**
         * <p>
         * An array of shard objects associated with this stream. Each shard contains a subset of the stream's data
         * records and has its own unique identifier. The collection of shards represents the complete stream data.
         * </p>
         * 
         * @param shards
         *        An array of shard objects associated with this stream. Each shard contains a subset of the stream's
         *        data records and has its own unique identifier. The collection of shards represents the complete
         *        stream data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Shard... shards);

        /**
         * <p>
         * An array of shard objects associated with this stream. Each shard contains a subset of the stream's data
         * records and has its own unique identifier. The collection of shards represents the complete stream data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.Shard.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.keyspacesstreams.model.Shard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.Shard.Builder#build()} is called immediately
         * and its result is passed to {@link #shards(List<Shard>)}.
         * 
         * @param shards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspacesstreams.model.Shard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shards(java.util.Collection<Shard>)
         */
        Builder shards(Consumer<Shard.Builder>... shards);

        /**
         * <p>
         * A pagination token that can be used in a subsequent <code>GetStream</code> request. This token is returned if
         * the response contains more shards than can be returned in a single response.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent <code>GetStream</code> request. This token is
         *        returned if the response contains more shards than can be returned in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KeyspacesStreamsResponse.BuilderImpl implements Builder {
        private String streamArn;

        private String streamLabel;

        private String streamStatus;

        private String streamViewType;

        private Instant creationRequestDateTime;

        private String keyspaceName;

        private String tableName;

        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamResponse model) {
            super(model);
            streamArn(model.streamArn);
            streamLabel(model.streamLabel);
            streamStatus(model.streamStatus);
            streamViewType(model.streamViewType);
            creationRequestDateTime(model.creationRequestDateTime);
            keyspaceName(model.keyspaceName);
            tableName(model.tableName);
            shards(model.shards);
            nextToken(model.nextToken);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getStreamLabel() {
            return streamLabel;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final String getStreamViewType() {
            return streamViewType;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType == null ? null : streamViewType.toString());
            return this;
        }

        public final Instant getCreationRequestDateTime() {
            return creationRequestDateTime;
        }

        public final void setCreationRequestDateTime(Instant creationRequestDateTime) {
            this.creationRequestDateTime = creationRequestDateTime;
        }

        @Override
        public final Builder creationRequestDateTime(Instant creationRequestDateTime) {
            this.creationRequestDateTime = creationRequestDateTime;
            return this;
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<Shard.Builder> getShards() {
            List<Shard.Builder> result = ShardDescriptionListCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardDescriptionListCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard... shards) {
            shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder>... shards) {
            shards(Stream.of(shards).map(c -> Shard.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetStreamResponse build() {
            return new GetStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
