/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspacesstreams.model.SequenceNumberRange;
import software.amazon.awssdk.services.keyspacesstreams.model.ShardIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Shard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Shard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shardId").getter(Shard.getter(Shard::shardId)).setter(Shard.setter(Builder::shardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardId").build()}).build();
    private static final SdkField<SequenceNumberRange> SEQUENCE_NUMBER_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sequenceNumberRange").getter(Shard.getter(Shard::sequenceNumberRange)).setter(Shard.setter(Builder::sequenceNumberRange)).constructor(SequenceNumberRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceNumberRange").build()}).build();
    private static final SdkField<List<String>> PARENT_SHARD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parentShardIds").getter(Shard.getter(Shard::parentShardIds)).setter(Shard.setter(Builder::parentShardIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentShardIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD, SEQUENCE_NUMBER_RANGE_FIELD, PARENT_SHARD_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Shard.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String shardId;
    private final SequenceNumberRange sequenceNumberRange;
    private final List<String> parentShardIds;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumberRange = builder.sequenceNumberRange;
        this.parentShardIds = builder.parentShardIds;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final SequenceNumberRange sequenceNumberRange() {
        return this.sequenceNumberRange;
    }

    public final boolean hasParentShardIds() {
        return this.parentShardIds != null && !(this.parentShardIds instanceof SdkAutoConstructList);
    }

    public final List<String> parentShardIds() {
        return this.parentShardIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumberRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParentShardIds() ? this.parentShardIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        return Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.sequenceNumberRange(), other.sequenceNumberRange()) && this.hasParentShardIds() == other.hasParentShardIds() && Objects.equals(this.parentShardIds(), other.parentShardIds());
    }

    public final String toString() {
        return ToString.builder((String)"Shard").add("ShardId", (Object)this.shardId()).add("SequenceNumberRange", (Object)this.sequenceNumberRange()).add("ParentShardIds", this.hasParentShardIds() ? this.parentShardIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "sequenceNumberRange": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumberRange()));
            }
            case "parentShardIds": {
                return Optional.ofNullable(clazz.cast(this.parentShardIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shardId", SHARD_ID_FIELD);
        map.put("sequenceNumberRange", SEQUENCE_NUMBER_RANGE_FIELD);
        map.put("parentShardIds", PARENT_SHARD_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Shard, T> g) {
        return obj -> g.apply((Shard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private SequenceNumberRange sequenceNumberRange;
        private List<String> parentShardIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            this.shardId(model.shardId);
            this.sequenceNumberRange(model.sequenceNumberRange);
            this.parentShardIds(model.parentShardIds);
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return this.sequenceNumberRange != null ? this.sequenceNumberRange.toBuilder() : null;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final Collection<String> getParentShardIds() {
            if (this.parentShardIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parentShardIds;
        }

        public final void setParentShardIds(Collection<String> parentShardIds) {
            this.parentShardIds = ShardIdListCopier.copy(parentShardIds);
        }

        @Override
        public final Builder parentShardIds(Collection<String> parentShardIds) {
            this.parentShardIds = ShardIdListCopier.copy(parentShardIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentShardIds(String ... parentShardIds) {
            this.parentShardIds(Arrays.asList(parentShardIds));
            return this;
        }

        public Shard build() {
            return new Shard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Shard> {
        public Builder shardId(String var1);

        public Builder sequenceNumberRange(SequenceNumberRange var1);

        default public Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return this.sequenceNumberRange((SequenceNumberRange)((SequenceNumberRange.Builder)SequenceNumberRange.builder().applyMutation(sequenceNumberRange)).build());
        }

        public Builder parentShardIds(Collection<String> var1);

        public Builder parentShardIds(String ... var1);
    }
}

