/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.keyspacesstreams.DefaultKeyspacesStreamsClientBuilder;
import software.amazon.awssdk.services.keyspacesstreams.KeyspacesStreamsClientBuilder;
import software.amazon.awssdk.services.keyspacesstreams.KeyspacesStreamsServiceClientConfiguration;
import software.amazon.awssdk.services.keyspacesstreams.model.AccessDeniedException;
import software.amazon.awssdk.services.keyspacesstreams.model.GetRecordsRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetRecordsResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.InternalServerException;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesStreamsException;
import software.amazon.awssdk.services.keyspacesstreams.model.ListStreamsRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.ListStreamsResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.ResourceNotFoundException;
import software.amazon.awssdk.services.keyspacesstreams.model.ThrottlingException;
import software.amazon.awssdk.services.keyspacesstreams.model.ValidationException;
import software.amazon.awssdk.services.keyspacesstreams.paginators.GetStreamIterable;
import software.amazon.awssdk.services.keyspacesstreams.paginators.ListStreamsIterable;

@SdkPublicApi
@ThreadSafe
public interface KeyspacesStreamsClient
extends AwsClient {
    public static final String SERVICE_NAME = "cassandra";
    public static final String SERVICE_METADATA_ID = "cassandra-streams";

    default public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        throw new UnsupportedOperationException();
    }

    default public GetRecordsResponse getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return this.getRecords((GetRecordsRequest)((Object)((GetRecordsRequest.Builder)GetRecordsRequest.builder().applyMutation(getRecordsRequest)).build()));
    }

    default public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        throw new UnsupportedOperationException();
    }

    default public GetShardIteratorResponse getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return this.getShardIterator((GetShardIteratorRequest)((Object)((GetShardIteratorRequest.Builder)GetShardIteratorRequest.builder().applyMutation(getShardIteratorRequest)).build()));
    }

    default public GetStreamResponse getStream(GetStreamRequest getStreamRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        throw new UnsupportedOperationException();
    }

    default public GetStreamResponse getStream(Consumer<GetStreamRequest.Builder> getStreamRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return this.getStream((GetStreamRequest)((Object)((GetStreamRequest.Builder)GetStreamRequest.builder().applyMutation(getStreamRequest)).build()));
    }

    default public GetStreamIterable getStreamPaginator(GetStreamRequest getStreamRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return new GetStreamIterable(this, getStreamRequest);
    }

    default public GetStreamIterable getStreamPaginator(Consumer<GetStreamRequest.Builder> getStreamRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return this.getStreamPaginator((GetStreamRequest)((Object)((GetStreamRequest.Builder)GetStreamRequest.builder().applyMutation(getStreamRequest)).build()));
    }

    default public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    default public ListStreamsIterable listStreamsPaginator(ListStreamsRequest listStreamsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return new ListStreamsIterable(this, listStreamsRequest);
    }

    default public ListStreamsIterable listStreamsPaginator(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesStreamsException {
        return this.listStreamsPaginator((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    public static KeyspacesStreamsClient create() {
        return (KeyspacesStreamsClient)KeyspacesStreamsClient.builder().build();
    }

    public static KeyspacesStreamsClientBuilder builder() {
        return new DefaultKeyspacesStreamsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public KeyspacesStreamsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

