/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a row in an Amazon Keyspaces table, containing regular column values, static column values, and row-level
 * metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyspacesRow implements SdkPojo, Serializable, ToCopyableBuilder<KeyspacesRow.Builder, KeyspacesRow> {
    private static final SdkField<Map<String, KeyspacesCell>> VALUE_CELLS_FIELD = SdkField
            .<Map<String, KeyspacesCell>> builder(MarshallingType.MAP)
            .memberName("valueCells")
            .getter(getter(KeyspacesRow::valueCells))
            .setter(setter(Builder::valueCells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueCells").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<KeyspacesCell> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, KeyspacesCell>> STATIC_CELLS_FIELD = SdkField
            .<Map<String, KeyspacesCell>> builder(MarshallingType.MAP)
            .memberName("staticCells")
            .getter(getter(KeyspacesRow::staticCells))
            .setter(setter(Builder::staticCells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticCells").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<KeyspacesCell> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<KeyspacesMetadata> ROW_METADATA_FIELD = SdkField
            .<KeyspacesMetadata> builder(MarshallingType.SDK_POJO).memberName("rowMetadata")
            .getter(getter(KeyspacesRow::rowMetadata)).setter(setter(Builder::rowMetadata))
            .constructor(KeyspacesMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_CELLS_FIELD,
            STATIC_CELLS_FIELD, ROW_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, KeyspacesCell> valueCells;

    private final Map<String, KeyspacesCell> staticCells;

    private final KeyspacesMetadata rowMetadata;

    private KeyspacesRow(BuilderImpl builder) {
        this.valueCells = builder.valueCells;
        this.staticCells = builder.staticCells;
        this.rowMetadata = builder.rowMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueCells property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueCells() {
        return valueCells != null && !(valueCells instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of regular (non-static) column cells in the row, where keys are column names and values are the
     * corresponding cells.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueCells} method.
     * </p>
     * 
     * @return A map of regular (non-static) column cells in the row, where keys are column names and values are the
     *         corresponding cells.
     */
    public final Map<String, KeyspacesCell> valueCells() {
        return valueCells;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticCells property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaticCells() {
        return staticCells != null && !(staticCells instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of static column cells shared by all rows with the same partition key, where keys are column names and
     * values are the corresponding cells.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticCells} method.
     * </p>
     * 
     * @return A map of static column cells shared by all rows with the same partition key, where keys are column names
     *         and values are the corresponding cells.
     */
    public final Map<String, KeyspacesCell> staticCells() {
        return staticCells;
    }

    /**
     * <p>
     * Metadata that applies to the entire row, such as timestamps and TTL information.
     * </p>
     * 
     * @return Metadata that applies to the entire row, such as timestamps and TTL information.
     */
    public final KeyspacesMetadata rowMetadata() {
        return rowMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValueCells() ? valueCells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticCells() ? staticCells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rowMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspacesRow)) {
            return false;
        }
        KeyspacesRow other = (KeyspacesRow) obj;
        return hasValueCells() == other.hasValueCells() && Objects.equals(valueCells(), other.valueCells())
                && hasStaticCells() == other.hasStaticCells() && Objects.equals(staticCells(), other.staticCells())
                && Objects.equals(rowMetadata(), other.rowMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyspacesRow").add("ValueCells", hasValueCells() ? valueCells() : null)
                .add("StaticCells", hasStaticCells() ? staticCells() : null).add("RowMetadata", rowMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "valueCells":
            return Optional.ofNullable(clazz.cast(valueCells()));
        case "staticCells":
            return Optional.ofNullable(clazz.cast(staticCells()));
        case "rowMetadata":
            return Optional.ofNullable(clazz.cast(rowMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("valueCells", VALUE_CELLS_FIELD);
        map.put("staticCells", STATIC_CELLS_FIELD);
        map.put("rowMetadata", ROW_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspacesRow, T> g) {
        return obj -> g.apply((KeyspacesRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyspacesRow> {
        /**
         * <p>
         * A map of regular (non-static) column cells in the row, where keys are column names and values are the
         * corresponding cells.
         * </p>
         * 
         * @param valueCells
         *        A map of regular (non-static) column cells in the row, where keys are column names and values are the
         *        corresponding cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueCells(Map<String, KeyspacesCell> valueCells);

        /**
         * <p>
         * A map of static column cells shared by all rows with the same partition key, where keys are column names and
         * values are the corresponding cells.
         * </p>
         * 
         * @param staticCells
         *        A map of static column cells shared by all rows with the same partition key, where keys are column
         *        names and values are the corresponding cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticCells(Map<String, KeyspacesCell> staticCells);

        /**
         * <p>
         * Metadata that applies to the entire row, such as timestamps and TTL information.
         * </p>
         * 
         * @param rowMetadata
         *        Metadata that applies to the entire row, such as timestamps and TTL information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowMetadata(KeyspacesMetadata rowMetadata);

        /**
         * <p>
         * Metadata that applies to the entire row, such as timestamps and TTL information.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyspacesMetadata.Builder} avoiding the
         * need to create one manually via {@link KeyspacesMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyspacesMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #rowMetadata(KeyspacesMetadata)}.
         * 
         * @param rowMetadata
         *        a consumer that will call methods on {@link KeyspacesMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowMetadata(KeyspacesMetadata)
         */
        default Builder rowMetadata(Consumer<KeyspacesMetadata.Builder> rowMetadata) {
            return rowMetadata(KeyspacesMetadata.builder().applyMutation(rowMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, KeyspacesCell> valueCells = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, KeyspacesCell> staticCells = DefaultSdkAutoConstructMap.getInstance();

        private KeyspacesMetadata rowMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspacesRow model) {
            valueCells(model.valueCells);
            staticCells(model.staticCells);
            rowMetadata(model.rowMetadata);
        }

        public final Map<String, KeyspacesCell.Builder> getValueCells() {
            Map<String, KeyspacesCell.Builder> result = KeyspacesCellsCopier.copyToBuilder(this.valueCells);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setValueCells(Map<String, KeyspacesCell.BuilderImpl> valueCells) {
            this.valueCells = KeyspacesCellsCopier.copyFromBuilder(valueCells);
        }

        @Override
        public final Builder valueCells(Map<String, KeyspacesCell> valueCells) {
            this.valueCells = KeyspacesCellsCopier.copy(valueCells);
            return this;
        }

        public final Map<String, KeyspacesCell.Builder> getStaticCells() {
            Map<String, KeyspacesCell.Builder> result = KeyspacesCellsCopier.copyToBuilder(this.staticCells);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStaticCells(Map<String, KeyspacesCell.BuilderImpl> staticCells) {
            this.staticCells = KeyspacesCellsCopier.copyFromBuilder(staticCells);
        }

        @Override
        public final Builder staticCells(Map<String, KeyspacesCell> staticCells) {
            this.staticCells = KeyspacesCellsCopier.copy(staticCells);
            return this;
        }

        public final KeyspacesMetadata.Builder getRowMetadata() {
            return rowMetadata != null ? rowMetadata.toBuilder() : null;
        }

        public final void setRowMetadata(KeyspacesMetadata.BuilderImpl rowMetadata) {
            this.rowMetadata = rowMetadata != null ? rowMetadata.build() : null;
        }

        @Override
        public final Builder rowMetadata(KeyspacesMetadata rowMetadata) {
            this.rowMetadata = rowMetadata;
            return this;
        }

        @Override
        public KeyspacesRow build() {
            return new KeyspacesRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
