/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.keyspacesstreams.KeyspacesStreamsClient;
import software.amazon.awssdk.services.keyspacesstreams.internal.UserAgentUtils;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.Shard;

public class GetStreamIterable
implements SdkIterable<GetStreamResponse> {
    private final KeyspacesStreamsClient client;
    private final GetStreamRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetStreamIterable(KeyspacesStreamsClient client, GetStreamRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetStreamResponseFetcher();
    }

    public Iterator<GetStreamResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Shard> shards() {
        Function<GetStreamResponse, Iterator> getIterator = response -> {
            if (response != null && response.shards() != null) {
                return response.shards().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetStreamResponseFetcher
    implements SyncPageFetcher<GetStreamResponse> {
        private GetStreamResponseFetcher() {
        }

        public boolean hasNextPage(GetStreamResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetStreamResponse nextPage(GetStreamResponse previousPage) {
            if (previousPage == null) {
                return GetStreamIterable.this.client.getStream(GetStreamIterable.this.firstRequest);
            }
            return GetStreamIterable.this.client.getStream((GetStreamRequest)((Object)GetStreamIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

